/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StandardServletEnvironment;

@Order(value=-2147483628)
class OnWebApplicationCondition
extends SpringBootCondition {
    private static final String WEB_CONTEXT_CLASS = "org.springframework.web.context.support.GenericWebApplicationContext";

    OnWebApplicationCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean webApplicationRequired = metadata.isAnnotated(ConditionalOnWebApplication.class.getName());
        ConditionOutcome webApplication = this.isWebApplication(context, metadata);
        if (webApplicationRequired && !webApplication.isMatch()) {
            return ConditionOutcome.noMatch(webApplication.getMessage());
        }
        if (!webApplicationRequired && webApplication.isMatch()) {
            return ConditionOutcome.noMatch(webApplication.getMessage());
        }
        return ConditionOutcome.match(webApplication.getMessage());
    }

    private ConditionOutcome isWebApplication(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Object[] scopes;
        if (!ClassUtils.isPresent((String)WEB_CONTEXT_CLASS, (ClassLoader)context.getClassLoader())) {
            return ConditionOutcome.noMatch("web application classes not found");
        }
        if (context.getBeanFactory() != null && ObjectUtils.containsElement((Object[])(scopes = context.getBeanFactory().getRegisteredScopeNames()), (Object)"session")) {
            return ConditionOutcome.match("found web application 'session' scope");
        }
        if (context.getEnvironment() instanceof StandardServletEnvironment) {
            return ConditionOutcome.match("found web application StandardServletEnvironment");
        }
        if (context.getResourceLoader() instanceof WebApplicationContext) {
            return ConditionOutcome.match("found web application WebApplicationContext");
        }
        return ConditionOutcome.noMatch("not a web application");
    }
}

