/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;

class AutoConfigurationSorter {
    private final CachingMetadataReaderFactory metadataReaderFactory;

    AutoConfigurationSorter(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public List<String> getInPriorityOrder(Collection<String> classNames) throws IOException {
        final AutoConfigurationClasses classes = new AutoConfigurationClasses((MetadataReaderFactory)this.metadataReaderFactory, classNames);
        List<String> orderedClassNames = new ArrayList<String>(classNames);
        Collections.sort(orderedClassNames);
        Collections.sort(orderedClassNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i2;
                int i1 = classes.get(o1).getOrder();
                return i1 < (i2 = classes.get(o2).getOrder()) ? -1 : (i1 > i2 ? 1 : 0);
            }
        });
        orderedClassNames = this.sortByAnnotation(classes, orderedClassNames);
        return orderedClassNames;
    }

    private List<String> sortByAnnotation(AutoConfigurationClasses classes, List<String> classNames) {
        ArrayList<String> tosort = new ArrayList<String>(classNames);
        LinkedHashSet<String> sorted = new LinkedHashSet<String>();
        LinkedHashSet<String> processing = new LinkedHashSet<String>();
        while (!tosort.isEmpty()) {
            this.doSortByAfterAnnotation(classes, tosort, sorted, processing, null);
        }
        return new ArrayList<String>(sorted);
    }

    private void doSortByAfterAnnotation(AutoConfigurationClasses classes, List<String> tosort, Set<String> sorted, Set<String> processing, String current) {
        if (current == null) {
            current = tosort.remove(0);
        }
        processing.add(current);
        for (String after : classes.getClassesRequestedAfter(current)) {
            Assert.state((!processing.contains(after) ? 1 : 0) != 0, (String)("AutoConfigure cycle detected between " + current + " and " + after));
            if (sorted.contains(after) || !tosort.contains(after)) continue;
            this.doSortByAfterAnnotation(classes, tosort, sorted, processing, after);
        }
        processing.remove(current);
        sorted.add(current);
    }

    private static class AutoConfigurationClass {
        private final AnnotationMetadata metadata;

        AutoConfigurationClass(MetadataReader metadataReader) {
            this.metadata = metadataReader.getAnnotationMetadata();
        }

        public int getOrder() {
            Map orderedAnnotation = this.metadata.getAnnotationAttributes(AutoConfigureOrder.class.getName());
            return orderedAnnotation == null ? Integer.MAX_VALUE : (Integer)orderedAnnotation.get("value");
        }

        public Set<String> getBefore() {
            return this.getAnnotationValue(AutoConfigureBefore.class);
        }

        public Set<String> getAfter() {
            return this.getAnnotationValue(AutoConfigureAfter.class);
        }

        private Set<String> getAnnotationValue(Class<?> annotation) {
            Map attributes = this.metadata.getAnnotationAttributes(annotation.getName(), true);
            if (attributes == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> value = new LinkedHashSet<String>();
            Collections.addAll(value, (String[])attributes.get("value"));
            Collections.addAll(value, (String[])attributes.get("name"));
            return value;
        }
    }

    private static class AutoConfigurationClasses {
        private final Map<String, AutoConfigurationClass> classes = new HashMap<String, AutoConfigurationClass>();

        AutoConfigurationClasses(MetadataReaderFactory metadataReaderFactory, Collection<String> classNames) throws IOException {
            for (String className : classNames) {
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(className);
                this.classes.put(className, new AutoConfigurationClass(metadataReader));
            }
        }

        public AutoConfigurationClass get(String className) {
            return this.classes.get(className);
        }

        public Set<String> getClassesRequestedAfter(String className) {
            LinkedHashSet<String> rtn = new LinkedHashSet<String>();
            rtn.addAll(this.get(className).getAfter());
            for (Map.Entry<String, AutoConfigurationClass> entry : this.classes.entrySet()) {
                if (!entry.getValue().getBefore().contains(className)) continue;
                rtn.add(entry.getKey());
            }
            return rtn;
        }
    }
}

