/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class GroovyTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view, Environment environment, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent((String)"groovy.text.TemplateEngine", (ClassLoader)classLoader)) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.groovy.template.");
            String prefix = resolver.getProperty("prefix", "");
            String suffix = resolver.getProperty("suffix", ".tpl");
            return resourceLoader.getResource(prefix + view + suffix).exists();
        }
        return false;
    }
}

