/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.dao;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;

@ConditionalOnClass(value={PersistenceExceptionTranslationPostProcessor.class})
public class PersistenceExceptionTranslationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PersistenceExceptionTranslationPostProcessor.class})
    @ConditionalOnProperty(prefix="spring.dao.exceptiontranslation", name={"enabled"}, matchIfMissing=true)
    public static PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor(Environment environment) {
        PersistenceExceptionTranslationPostProcessor postProcessor = new PersistenceExceptionTranslationPostProcessor();
        postProcessor.setProxyTargetClass(PersistenceExceptionTranslationAutoConfiguration.determineProxyTargetClass(environment));
        return postProcessor;
    }

    private static boolean determineProxyTargetClass(Environment environment) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.aop.");
        Boolean value = (Boolean)resolver.getProperty("proxyTargetClass", Boolean.class);
        return value != null ? value : true;
    }
}

