/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.orm.jpa.DataSourceInitializedPublisher;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableConfigurationProperties(value={JpaProperties.class})
@Import(value={DataSourceInitializedPublisher.Registrar.class})
public abstract class JpaBaseConfiguration
implements BeanFactoryAware {
    private final DataSource dataSource;
    private final JpaProperties properties;
    private final JtaTransactionManager jtaTransactionManager;
    private final TransactionManagerCustomizers transactionManagerCustomizers;
    private ConfigurableListableBeanFactory beanFactory;

    protected JpaBaseConfiguration(DataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManager, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        this.dataSource = dataSource;
        this.properties = properties;
        this.jtaTransactionManager = (JtaTransactionManager)jtaTransactionManager.getIfAvailable();
        this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
        }
        return transactionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaVendorAdapter jpaVendorAdapter() {
        AbstractJpaVendorAdapter adapter = this.createJpaVendorAdapter();
        adapter.setShowSql(this.properties.isShowSql());
        adapter.setDatabase(this.properties.determineDatabase(this.dataSource));
        adapter.setDatabasePlatform(this.properties.getDatabasePlatform());
        adapter.setGenerateDdl(this.properties.isGenerateDdl());
        return adapter;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityManagerFactoryBuilder entityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, ObjectProvider<PersistenceUnitManager> persistenceUnitManager) {
        EntityManagerFactoryBuilder builder = new EntityManagerFactoryBuilder(jpaVendorAdapter, this.properties.getProperties(), (PersistenceUnitManager)persistenceUnitManager.getIfAvailable());
        builder.setCallback(this.getVendorCallback());
        return builder;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={LocalContainerEntityManagerFactoryBean.class, EntityManagerFactory.class})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder factoryBuilder) {
        Map<String, Object> vendorProperties = this.getVendorProperties();
        this.customizeVendorProperties(vendorProperties);
        return factoryBuilder.dataSource(this.dataSource).packages(this.getPackagesToScan()).properties(vendorProperties).mappingResources(this.getMappingResources()).jta(this.isJta()).build();
    }

    protected abstract AbstractJpaVendorAdapter createJpaVendorAdapter();

    protected abstract Map<String, Object> getVendorProperties();

    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
    }

    protected EntityManagerFactoryBuilder.EntityManagerFactoryBeanCallback getVendorCallback() {
        return null;
    }

    protected String[] getPackagesToScan() {
        List<String> packages = EntityScanPackages.get((BeanFactory)this.beanFactory).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
            packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        }
        return packages.toArray(new String[packages.size()]);
    }

    private String[] getMappingResources() {
        List<String> mappingResources = this.properties.getMappingResources();
        return mappingResources.toArray(new String[mappingResources.size()]);
    }

    protected JtaTransactionManager getJtaTransactionManager() {
        return this.jtaTransactionManager;
    }

    protected final boolean isJta() {
        return this.jtaTransactionManager != null;
    }

    protected final JpaProperties getProperties() {
        return this.properties;
    }

    protected final DataSource getDataSource() {
        return this.dataSource;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    @ConditionalOnMissingBean(value={OpenEntityManagerInViewInterceptor.class, OpenEntityManagerInViewFilter.class})
    @ConditionalOnProperty(prefix="spring.jpa", name={"open-in-view"}, havingValue="true", matchIfMissing=true)
    protected static class JpaWebConfiguration {
        protected JpaWebConfiguration() {
        }

        @Configuration
        protected static class JpaWebMvcConfiguration
        implements WebMvcConfigurer {
            private static final Log logger = LogFactory.getLog(JpaWebMvcConfiguration.class);
            private final JpaProperties jpaProperties;

            protected JpaWebMvcConfiguration(JpaProperties jpaProperties) {
                this.jpaProperties = jpaProperties;
            }

            @Bean
            public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
                if (this.jpaProperties.getOpenInView() == null) {
                    logger.warn((Object)"spring.jpa.open-in-view is enabled by default. Therefore, database queries may be performed during view rendering. Explicitly configure spring.jpa.open-in-view to disable this warning");
                }
                return new OpenEntityManagerInViewInterceptor();
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addWebRequestInterceptor((WebRequestInterceptor)this.openEntityManagerInViewInterceptor());
            }
        }
    }
}

