/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded.undertow;

import io.undertow.UndertowOptions;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.core.env.Environment;

public final class UndertowCustomizer {
    private UndertowCustomizer() {
    }

    public static void customizeUndertow(ServerProperties serverProperties, Environment environment, ConfigurableUndertowWebServerFactory factory) {
        ServerProperties.Undertow undertowProperties = serverProperties.getUndertow();
        ServerProperties.Undertow.Accesslog accesslogProperties = undertowProperties.getAccesslog();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from(undertowProperties::getBufferSize).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setBufferSize(arg_0));
        propertyMapper.from(undertowProperties::getIoThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setIoThreads(arg_0));
        propertyMapper.from(undertowProperties::getWorkerThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setWorkerThreads(arg_0));
        propertyMapper.from(undertowProperties::getDirectBuffers).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseDirectBuffers(arg_0));
        propertyMapper.from(accesslogProperties::getEnabled).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogEnabled(arg_0));
        propertyMapper.from(accesslogProperties::getDir).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogDirectory(arg_0));
        propertyMapper.from(accesslogProperties::getPattern).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPattern(arg_0));
        propertyMapper.from(accesslogProperties::getPrefix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPrefix(arg_0));
        propertyMapper.from(accesslogProperties::getSuffix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogSuffix(arg_0));
        propertyMapper.from(accesslogProperties::isRotate).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogRotate(arg_0));
        propertyMapper.from(() -> UndertowCustomizer.getOrDeduceUseForwardHeaders(serverProperties, environment)).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseForwardHeaders(arg_0));
        propertyMapper.from(serverProperties::getMaxHttpHeaderSize).when(UndertowCustomizer::isPositive).to(maxHttpHeaderSize -> UndertowCustomizer.customizeMaxHttpHeaderSize(factory, maxHttpHeaderSize));
        propertyMapper.from(undertowProperties::getMaxHttpPostSize).when(UndertowCustomizer::isPositive).to(maxHttpPostSize -> UndertowCustomizer.customizeMaxHttpPostSize(factory, maxHttpPostSize));
        propertyMapper.from(serverProperties::getConnectionTimeout).to(connectionTimeout -> UndertowCustomizer.customizeConnectionTimeout(factory, connectionTimeout));
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> deploymentInfo.setEagerFilterInit(undertowProperties.isEagerFilterInit())});
    }

    private static boolean isPositive(Number value) {
        return value.longValue() > 0L;
    }

    private static void customizeConnectionTimeout(ConfigurableUndertowWebServerFactory factory, Duration connectionTimeout) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setSocketOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)((int)connectionTimeout.toMillis()))});
    }

    private static void customizeMaxHttpHeaderSize(ConfigurableUndertowWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)maxHttpHeaderSize)});
    }

    private static void customizeMaxHttpPostSize(ConfigurableUndertowWebServerFactory factory, long maxHttpPostSize) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)maxHttpPostSize)});
    }

    private static boolean getOrDeduceUseForwardHeaders(ServerProperties serverProperties, Environment environment) {
        if (serverProperties.isUseForwardHeaders() != null) {
            return serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)environment);
        return platform != null && platform.isUsingForwardHeaders();
    }
}

