/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.orm.jpa.DatabaseLookup;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.jpa")
public class JpaProperties {
    private Map<String, String> properties = new HashMap<String, String>();
    private final List<String> mappingResources = new ArrayList<String>();
    private String databasePlatform;
    private Database database;
    private boolean generateDdl = false;
    private boolean showSql = false;
    private Boolean openInView;
    private Hibernate hibernate = new Hibernate();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public List<String> getMappingResources() {
        return this.mappingResources;
    }

    public String getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(String databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public boolean isGenerateDdl() {
        return this.generateDdl;
    }

    public void setGenerateDdl(boolean generateDdl) {
        this.generateDdl = generateDdl;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public Boolean getOpenInView() {
        return this.openInView;
    }

    public void setOpenInView(Boolean openInView) {
        this.openInView = openInView;
    }

    public Hibernate getHibernate() {
        return this.hibernate;
    }

    public void setHibernate(Hibernate hibernate) {
        this.hibernate = hibernate;
    }

    public Map<String, Object> getHibernateProperties(HibernateSettings settings) {
        return this.hibernate.getAdditionalProperties(this.properties, settings);
    }

    public Database determineDatabase(DataSource dataSource) {
        if (this.database != null) {
            return this.database;
        }
        return DatabaseLookup.getDatabase(dataSource);
    }

    public static class Naming {
        private static final String DEFAULT_PHYSICAL_STRATEGY = "org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy";
        private static final String DEFAULT_IMPLICIT_STRATEGY = "org.springframework.boot.orm.jpa.hibernate.SpringImplicitNamingStrategy";
        private String implicitStrategy;
        private String physicalStrategy;

        public String getImplicitStrategy() {
            return this.implicitStrategy;
        }

        public void setImplicitStrategy(String implicitStrategy) {
            this.implicitStrategy = implicitStrategy;
        }

        public String getPhysicalStrategy() {
            return this.physicalStrategy;
        }

        public void setPhysicalStrategy(String physicalStrategy) {
            this.physicalStrategy = physicalStrategy;
        }

        private void applyNamingStrategies(Map<String, Object> properties) {
            this.applyNamingStrategy(properties, "hibernate.implicit_naming_strategy", this.implicitStrategy, DEFAULT_IMPLICIT_STRATEGY);
            this.applyNamingStrategy(properties, "hibernate.physical_naming_strategy", this.physicalStrategy, DEFAULT_PHYSICAL_STRATEGY);
        }

        private void applyNamingStrategy(Map<String, Object> properties, String key, Object strategy, Object defaultStrategy) {
            if (strategy != null) {
                properties.put(key, strategy);
            } else if (defaultStrategy != null && !properties.containsKey(key)) {
                properties.put(key, defaultStrategy);
            }
        }
    }

    public static class Hibernate {
        private static final String USE_NEW_ID_GENERATOR_MAPPINGS = "hibernate.id.new_generator_mappings";
        private String ddlAuto;
        private Boolean useNewIdGeneratorMappings;
        private final Naming naming = new Naming();

        public String getDdlAuto() {
            return this.ddlAuto;
        }

        public void setDdlAuto(String ddlAuto) {
            this.ddlAuto = ddlAuto;
        }

        public Boolean isUseNewIdGeneratorMappings() {
            return this.useNewIdGeneratorMappings;
        }

        public void setUseNewIdGeneratorMappings(Boolean useNewIdGeneratorMappings) {
            this.useNewIdGeneratorMappings = useNewIdGeneratorMappings;
        }

        public Naming getNaming() {
            return this.naming;
        }

        private Map<String, Object> getAdditionalProperties(Map<String, String> existing, HibernateSettings settings) {
            HashMap<String, Object> result = new HashMap<String, Object>(existing);
            this.applyNewIdGeneratorMappings(result);
            this.getNaming().applyNamingStrategies(result);
            String ddlAuto = this.determineDdlAuto(existing, settings::getDdlAuto);
            if (StringUtils.hasText((String)ddlAuto) && !"none".equals(ddlAuto)) {
                result.put("hibernate.hbm2ddl.auto", ddlAuto);
            } else {
                result.remove("hibernate.hbm2ddl.auto");
            }
            Collection<HibernatePropertiesCustomizer> customizers = settings.getHibernatePropertiesCustomizers();
            if (!ObjectUtils.isEmpty(customizers)) {
                customizers.forEach(customizer -> customizer.customize(result));
            }
            return result;
        }

        private void applyNewIdGeneratorMappings(Map<String, Object> result) {
            if (this.useNewIdGeneratorMappings != null) {
                result.put(USE_NEW_ID_GENERATOR_MAPPINGS, this.useNewIdGeneratorMappings.toString());
            } else if (!result.containsKey(USE_NEW_ID_GENERATOR_MAPPINGS)) {
                result.put(USE_NEW_ID_GENERATOR_MAPPINGS, "true");
            }
        }

        private String determineDdlAuto(Map<String, String> existing, Supplier<String> defaultDdlAuto) {
            String ddlAuto = existing.get("hibernate.hbm2ddl.auto");
            if (ddlAuto != null) {
                return ddlAuto;
            }
            return this.ddlAuto != null ? this.ddlAuto : defaultDdlAuto.get();
        }
    }
}

