/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.saml2;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="spring.security.saml2.relyingparty")
public class Saml2RelyingPartyProperties {
    private Map<String, Registration> registration = new LinkedHashMap<String, Registration>();

    public Map<String, Registration> getRegistration() {
        return this.registration;
    }

    public static class Identityprovider {
        private String entityId;
        private String ssoUrl;
        private Verification verification = new Verification();

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getSsoUrl() {
            return this.ssoUrl;
        }

        public void setSsoUrl(String ssoUrl) {
            this.ssoUrl = ssoUrl;
        }

        public Verification getVerification() {
            return this.verification;
        }

        public static class Verification {
            private List<Credential> credentials = new ArrayList<Credential>();

            public List<Credential> getCredentials() {
                return this.credentials;
            }

            public static class Credential {
                private Resource certificate;

                public Resource getCertificateLocation() {
                    return this.certificate;
                }

                public void setCertificateLocation(Resource certificate) {
                    this.certificate = certificate;
                }
            }
        }
    }

    public static class Registration {
        private final Signing signing = new Signing();
        private Identityprovider identityprovider = new Identityprovider();

        public Signing getSigning() {
            return this.signing;
        }

        Identityprovider getIdentityprovider() {
            return this.identityprovider;
        }

        public static class Signing {
            private List<Credential> credentials = new ArrayList<Credential>();

            public List<Credential> getCredentials() {
                return this.credentials;
            }

            public static class Credential {
                private Resource privateKeyLocation;
                private Resource certificateLocation;

                public Resource getPrivateKeyLocation() {
                    return this.privateKeyLocation;
                }

                public void setPrivateKeyLocation(Resource privateKey) {
                    this.privateKeyLocation = privateKey;
                }

                public Resource getCertificateLocation() {
                    return this.certificateLocation;
                }

                public void setCertificateLocation(Resource certificate) {
                    this.certificateLocation = certificate;
                }
            }
        }
    }
}

