/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.saml2;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.saml2.RegistrationConfiguredCondition;
import org.springframework.boot.autoconfigure.security.saml2.Saml2RelyingPartyProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Conditional(value={RegistrationConfiguredCondition.class})
@ConditionalOnMissingBean(value={RelyingPartyRegistrationRepository.class})
class Saml2RelyingPartyRegistrationConfiguration {
    Saml2RelyingPartyRegistrationConfiguration() {
    }

    @Bean
    RelyingPartyRegistrationRepository relyingPartyRegistrationRepository(Saml2RelyingPartyProperties properties) {
        List registrations = properties.getRegistration().entrySet().stream().map(this::asRegistration).collect(Collectors.toList());
        return new InMemoryRelyingPartyRegistrationRepository(registrations);
    }

    private RelyingPartyRegistration asRegistration(Map.Entry<String, Saml2RelyingPartyProperties.Registration> entry) {
        return this.asRegistration(entry.getKey(), entry.getValue());
    }

    private RelyingPartyRegistration asRegistration(String id, Saml2RelyingPartyProperties.Registration properties) {
        RelyingPartyRegistration.Builder builder = RelyingPartyRegistration.withRegistrationId((String)id);
        builder.assertionConsumerServiceUrlTemplate("{baseUrl}/login/saml2/sso/{registrationId}");
        builder.idpWebSsoUrl(properties.getIdentityprovider().getSsoUrl());
        builder.remoteIdpEntityId(properties.getIdentityprovider().getEntityId());
        builder.credentials(credentials -> credentials.addAll(this.asCredentials(properties)));
        return builder.build();
    }

    private List<Saml2X509Credential> asCredentials(Saml2RelyingPartyProperties.Registration properties) {
        ArrayList<Saml2X509Credential> credentials = new ArrayList<Saml2X509Credential>();
        properties.getSigning().getCredentials().stream().map(this::asSigningCredential).forEach(credentials::add);
        properties.getIdentityprovider().getVerification().getCredentials().stream().map(this::asVerificationCredential).forEach(credentials::add);
        return credentials;
    }

    private Saml2X509Credential asSigningCredential(Saml2RelyingPartyProperties.Registration.Signing.Credential properties) {
        RSAPrivateKey privateKey = this.readPrivateKey(properties.getPrivateKeyLocation());
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential((PrivateKey)privateKey, certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.SIGNING, Saml2X509Credential.Saml2X509CredentialType.DECRYPTION});
    }

    private Saml2X509Credential asVerificationCredential(Saml2RelyingPartyProperties.Identityprovider.Verification.Credential properties) {
        X509Certificate certificate = this.readCertificate(properties.getCertificateLocation());
        return new Saml2X509Credential(certificate, new Saml2X509Credential.Saml2X509CredentialType[]{Saml2X509Credential.Saml2X509CredentialType.ENCRYPTION, Saml2X509Credential.Saml2X509CredentialType.VERIFICATION});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RSAPrivateKey readPrivateKey(Resource location) {
        Assert.state((location != null ? 1 : 0) != 0, (String)"No private key location specified");
        Assert.state((boolean)location.exists(), (String)("Private key location '" + location + "' does not exist"));
        try (InputStream inputStream = location.getInputStream();){
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)RsaKeyConverters.pkcs8().convert((Object)inputStream);
            return rSAPrivateKey;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate readCertificate(Resource location) {
        Assert.state((location != null ? 1 : 0) != 0, (String)"No certificate location specified");
        Assert.state((boolean)location.exists(), (String)("Certificate  location '" + location + "' does not exist"));
        try (InputStream inputStream = location.getInputStream();){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
            return x509Certificate;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

