/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.time.Duration;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.session.JdbcSessionDataSourceInitializer;
import org.springframework.boot.autoconfigure.session.JdbcSessionProperties;
import org.springframework.boot.autoconfigure.session.ServletSessionCondition;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JdbcTemplate.class, JdbcIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={DataSource.class})
@Conditional(value={ServletSessionCondition.class})
@EnableConfigurationProperties(value={JdbcSessionProperties.class})
class JdbcSessionConfiguration {
    JdbcSessionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    JdbcSessionDataSourceInitializer jdbcSessionDataSourceInitializer(@SpringSessionDataSource ObjectProvider<DataSource> sessionDataSource, ObjectProvider<DataSource> dataSource, ResourceLoader resourceLoader, JdbcSessionProperties properties) {
        return new JdbcSessionDataSourceInitializer((DataSource)sessionDataSource.getIfAvailable(() -> dataSource.getObject()), resourceLoader, properties);
    }

    static class JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor
    extends AbstractDependsOnBeanFactoryPostProcessor {
        JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor(Class<?> ... dependencyTypes) {
            super(JdbcIndexedSessionRepository.class, dependencyTypes);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JdbcIndexedSessionRepositoryDependencyConfiguration {
        JdbcIndexedSessionRepositoryDependencyConfiguration() {
        }

        @Bean
        JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor dataSourceInitializerJdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor() {
            return new JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor(JdbcSessionDataSourceInitializer.class);
        }

        @Bean
        @ConditionalOnClass(name={"org.flywaydb.core.Flyway"})
        JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor flywayJdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor() {
            return new JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor(new Class[]{FlywayMigrationInitializer.class, Flyway.class});
        }

        @Bean
        @ConditionalOnClass(name={"liquibase.integration.spring.SpringLiquibase"})
        JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor liquibaseJdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor() {
            return new JdbcIndexedSessionRepositoryDependsOnBeanFactoryPostProcessor(SpringLiquibase.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class SpringBootJdbcHttpSessionConfiguration
    extends JdbcHttpSessionConfiguration {
        SpringBootJdbcHttpSessionConfiguration() {
        }

        @Autowired
        void customize(SessionProperties sessionProperties, JdbcSessionProperties jdbcSessionProperties, ServerProperties serverProperties) {
            Duration timeout = sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout());
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds((int)timeout.getSeconds());
            }
            this.setTableName(jdbcSessionProperties.getTableName());
            this.setCleanupCron(jdbcSessionProperties.getCleanupCron());
            this.setFlushMode(jdbcSessionProperties.getFlushMode());
            this.setSaveMode(jdbcSessionProperties.getSaveMode());
        }
    }
}

