/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.sql.init;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.sql.init.SettingsCreator;
import org.springframework.boot.autoconfigure.sql.init.SqlInitializationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.sql.init.AbstractScriptDatabaseInitializer;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={AbstractScriptDatabaseInitializer.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
class DataSourceInitializationConfiguration {
    DataSourceInitializationConfiguration() {
    }

    @Bean
    DataSourceScriptDatabaseInitializer dataSourceScriptDatabaseInitializer(DataSource dataSource, SqlInitializationProperties initializationProperties) {
        DatabaseInitializationSettings settings = SettingsCreator.createFrom(initializationProperties);
        return new DataSourceScriptDatabaseInitializer(DataSourceInitializationConfiguration.determineDataSource(dataSource, initializationProperties.getUsername(), initializationProperties.getPassword()), settings);
    }

    private static DataSource determineDataSource(DataSource dataSource, String username, String password) {
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            DataSourceBuilder.derivedFrom((DataSource)dataSource).username(username).password(password).type(SimpleDriverDataSource.class).build();
        }
        return dataSource;
    }
}

