/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.sql.init.DatabaseInitializationMode;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.util.StringUtils;

@Deprecated
class DataSourceInitializationConfiguration {
    DataSourceInitializationConfiguration() {
    }

    private static DataSource determineDataSource(Supplier<DataSource> dataSource, String username, String password) {
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            return DataSourceBuilder.derivedFrom((DataSource)dataSource.get()).type(SimpleDriverDataSource.class).username(username).password(password).build();
        }
        return dataSource.get();
    }

    private static List<String> scriptLocations(List<String> locations, String fallback, String platform) {
        if (locations != null) {
            return locations;
        }
        ArrayList<String> fallbackLocations = new ArrayList<String>();
        fallbackLocations.add("optional:classpath*:" + fallback + "-" + platform + ".sql");
        fallbackLocations.add("optional:classpath*:" + fallback + ".sql");
        return fallbackLocations;
    }

    private static DatabaseInitializationMode mapMode(DataSourceInitializationMode mode) {
        switch (mode) {
            case ALWAYS: {
                return DatabaseInitializationMode.ALWAYS;
            }
            case EMBEDDED: {
                return DatabaseInitializationMode.EMBEDDED;
            }
            case NEVER: {
                return DatabaseInitializationMode.NEVER;
            }
        }
        throw new IllegalStateException("Unexpected initialization mode '" + mode + "'");
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={DatabaseInitializationDependencyConfigurer.class})
    @Conditional(value={DataSourceInitializationCondition.class})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    @ConditionalOnMissingBean(value={DataSourceScriptDatabaseInitializer.class})
    static class SharedCredentialsDataSourceInitializationConfiguration {
        SharedCredentialsDataSourceInitializationConfiguration() {
        }

        @Bean
        DataSourceScriptDatabaseInitializer scriptDataSourceInitializer(DataSource dataSource, DataSourceProperties properties) {
            DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
            settings.setSchemaLocations(DataSourceInitializationConfiguration.scriptLocations(properties.getSchema(), "schema", properties.getPlatform()));
            settings.setDataLocations(DataSourceInitializationConfiguration.scriptLocations(properties.getData(), "data", properties.getPlatform()));
            settings.setContinueOnError(properties.isContinueOnError());
            settings.setSeparator(properties.getSeparator());
            settings.setEncoding(properties.getSqlScriptEncoding());
            settings.setMode(DataSourceInitializationConfiguration.mapMode(properties.getInitializationMode()));
            return new DataSourceScriptDatabaseInitializer(dataSource, settings);
        }

        static class DataSourceInitializationCondition
        extends SpringBootCondition {
            private static final Set<String> INITIALIZATION_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("spring.datasource.initialization-mode", "spring.datasource.platform", "spring.datasource.schema", "spring.datasource.schema[0]", "spring.datasource.schema-username", "spring.datasource.schema-password", "spring.datasource.data", "spring.datasource.data[0]", "spring.datasource.data-username", "spring.datasource.data-password", "spring.datasource.continue-on-error", "spring.datasource.separator", "spring.datasource.sql-script-encoding")));

            DataSourceInitializationCondition() {
            }

            @Override
            public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
                ConditionMessage.Builder message = ConditionMessage.forCondition("DataSource Initialization", new Object[0]);
                Environment environment = context.getEnvironment();
                Set configuredProperties = INITIALIZATION_PROPERTIES.stream().filter(arg_0 -> ((Environment)environment).containsProperty(arg_0)).collect(Collectors.toSet());
                if (configuredProperties.isEmpty()) {
                    return ConditionOutcome.noMatch(message.didNotFind("configured properties").items(INITIALIZATION_PROPERTIES));
                }
                return ConditionOutcome.match(message.found("configured property", "configured properties").items(configuredProperties));
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={DifferentCredentialsCondition.class})
    @Import(value={DatabaseInitializationDependencyConfigurer.class})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    @ConditionalOnMissingBean(value={DataSourceScriptDatabaseInitializer.class})
    static class InitializationSpecificCredentialsDataSourceInitializationConfiguration {
        InitializationSpecificCredentialsDataSourceInitializationConfiguration() {
        }

        @Bean
        DataSourceScriptDatabaseInitializer ddlOnlyScriptDataSourceInitializer(ObjectProvider<DataSource> dataSource, DataSourceProperties properties) {
            DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
            settings.setSchemaLocations(DataSourceInitializationConfiguration.scriptLocations(properties.getSchema(), "schema", properties.getPlatform()));
            settings.setContinueOnError(properties.isContinueOnError());
            settings.setSeparator(properties.getSeparator());
            settings.setEncoding(properties.getSqlScriptEncoding());
            settings.setMode(DataSourceInitializationConfiguration.mapMode(properties.getInitializationMode()));
            DataSource initializationDataSource = DataSourceInitializationConfiguration.determineDataSource(() -> dataSource.getObject(), properties.getSchemaUsername(), properties.getSchemaPassword());
            return new DataSourceScriptDatabaseInitializer(initializationDataSource, settings);
        }

        @Bean
        @DependsOn(value={"ddlOnlyScriptDataSourceInitializer"})
        DataSourceScriptDatabaseInitializer dmlOnlyScriptDataSourceInitializer(ObjectProvider<DataSource> dataSource, DataSourceProperties properties) {
            DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
            settings.setDataLocations(DataSourceInitializationConfiguration.scriptLocations(properties.getData(), "data", properties.getPlatform()));
            settings.setContinueOnError(properties.isContinueOnError());
            settings.setSeparator(properties.getSeparator());
            settings.setEncoding(properties.getSqlScriptEncoding());
            settings.setMode(DataSourceInitializationConfiguration.mapMode(properties.getInitializationMode()));
            DataSource initializationDataSource = DataSourceInitializationConfiguration.determineDataSource(() -> dataSource.getObject(), properties.getDataUsername(), properties.getDataPassword());
            return new DataSourceScriptDatabaseInitializer(initializationDataSource, settings);
        }

        static class DifferentCredentialsCondition
        extends AnyNestedCondition {
            DifferentCredentialsCondition() {
                super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
            }

            @ConditionalOnProperty(prefix="spring.datasource", name={"data-username"})
            static class DataCredentials {
                DataCredentials() {
                }
            }

            @ConditionalOnProperty(prefix="spring.datasource", name={"schema-username"})
            static class SchemaCredentials {
                SchemaCredentials() {
                }
            }
        }
    }
}

