/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.elasticsearch;

import co.elastic.clients.transport.ElasticsearchTransport;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchClientAutoConfiguration;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchClientConfigurations;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={ElasticsearchClientAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveElasticsearchClient.class, ElasticsearchTransport.class, Mono.class})
@EnableConfigurationProperties(value={ElasticsearchProperties.class})
@Import(value={ElasticsearchClientConfigurations.ElasticsearchTransportConfiguration.class})
public class ReactiveElasticsearchClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ElasticsearchTransport.class})
    ReactiveElasticsearchClient reactiveElasticsearchClient(ElasticsearchTransport transport) {
        return new ReactiveElasticsearchClient(transport);
    }
}

