/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.util.List;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.util.Assert;

public interface RedisConnectionDetails
extends ConnectionDetails {
    default public String getUsername() {
        return null;
    }

    default public String getPassword() {
        return null;
    }

    default public Standalone getStandalone() {
        return null;
    }

    default public Sentinel getSentinel() {
        return null;
    }

    default public Cluster getCluster() {
        return null;
    }

    public record Node(String host, int port) {
    }

    public static interface Cluster {
        public List<Node> getNodes();
    }

    public static interface Sentinel {
        public int getDatabase();

        public String getMaster();

        public List<Node> getNodes();

        public String getUsername();

        public String getPassword();
    }

    public static interface Standalone {
        public String getHost();

        public int getPort();

        default public int getDatabase() {
            return 0;
        }

        public static Standalone of(String host, int port) {
            return Standalone.of(host, port, 0);
        }

        public static Standalone of(final String host, final int port, final int database) {
            Assert.hasLength((String)host, (String)"'host' must not be empty");
            return new Standalone(){

                @Override
                public String getHost() {
                    return host;
                }

                @Override
                public int getPort() {
                    return port;
                }

                @Override
                public int getDatabase() {
                    return database;
                }
            };
        }
    }
}

