/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.servlet;

import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.autoconfigure.security.oauth2.resource.IssuerUriCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.KeyValueCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.JwkSetUriJwtDecoderBuilderCustomizer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.SupplierJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
class OAuth2ResourceServerJwtConfiguration {
    OAuth2ResourceServerJwtConfiguration() {
    }

    private static class JwtConverterPropertiesCondition
    extends AnyNestedCondition {
        JwtConverterPropertiesCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.authorities-claim-name"})
        static class OnAuthoritiesClaimName {
            OnAuthoritiesClaimName() {
            }
        }

        @ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.principal-claim-name"})
        static class OnPrincipalClaimName {
            OnPrincipalClaimName() {
            }
        }

        @ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.authority-prefix"})
        static class OnAuthorityPrefix {
            OnAuthorityPrefix() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={JwtAuthenticationConverter.class})
    @Conditional(value={JwtConverterPropertiesCondition.class})
    static class JwtConverterConfiguration {
        private final OAuth2ResourceServerProperties.Jwt properties;

        JwtConverterConfiguration(OAuth2ResourceServerProperties properties) {
            this.properties = properties.getJwt();
        }

        @Bean
        JwtAuthenticationConverter getJwtAuthenticationConverter() {
            JwtGrantedAuthoritiesConverter grantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)this.properties.getAuthorityPrefix()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthorityPrefix(arg_0));
            map.from((Object)this.properties.getAuthoritiesClaimDelimiter()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthoritiesClaimDelimiter(arg_0));
            map.from((Object)this.properties.getAuthoritiesClaimName()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthoritiesClaimName(arg_0));
            JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
            map.from((Object)this.properties.getPrincipalClaimName()).to(arg_0 -> ((JwtAuthenticationConverter)jwtAuthenticationConverter).setPrincipalClaimName(arg_0));
            jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)grantedAuthoritiesConverter);
            return jwtAuthenticationConverter;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnDefaultWebSecurity
    static class OAuth2SecurityFilterChainConfiguration {
        OAuth2SecurityFilterChainConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={JwtDecoder.class})
        SecurityFilterChain jwtSecurityFilterChain(HttpSecurity http) throws Exception {
            http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated());
            http.oauth2ResourceServer(resourceServer -> resourceServer.jwt(Customizer.withDefaults()));
            return (SecurityFilterChain)http.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={JwtDecoder.class})
    static class JwtDecoderConfiguration {
        private final OAuth2ResourceServerProperties.Jwt properties;
        private final List<OAuth2TokenValidator<Jwt>> additionalValidators;

        JwtDecoderConfiguration(OAuth2ResourceServerProperties properties, ObjectProvider<OAuth2TokenValidator<Jwt>> additionalValidators) {
            this.properties = properties.getJwt();
            this.additionalValidators = additionalValidators.orderedStream().toList();
        }

        @Bean
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
        JwtDecoder jwtDecoderByJwkKeySetUri(ObjectProvider<JwkSetUriJwtDecoderBuilderCustomizer> customizers) {
            NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder builder = NimbusJwtDecoder.withJwkSetUri((String)this.properties.getJwkSetUri()).jwsAlgorithms(this::jwsAlgorithms);
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            NimbusJwtDecoder nimbusJwtDecoder = builder.build();
            String issuerUri = this.properties.getIssuerUri();
            OAuth2TokenValidator defaultValidator = issuerUri != null ? JwtValidators.createDefaultWithIssuer((String)issuerUri) : JwtValidators.createDefault();
            nimbusJwtDecoder.setJwtValidator(this.getValidators((OAuth2TokenValidator<Jwt>)defaultValidator));
            return nimbusJwtDecoder;
        }

        private void jwsAlgorithms(Set<SignatureAlgorithm> signatureAlgorithms) {
            for (String algorithm : this.properties.getJwsAlgorithms()) {
                signatureAlgorithms.add(SignatureAlgorithm.from((String)algorithm));
            }
        }

        private OAuth2TokenValidator<Jwt> getValidators(OAuth2TokenValidator<Jwt> defaultValidator) {
            List<String> audiences = this.properties.getAudiences();
            if (CollectionUtils.isEmpty(audiences) && this.additionalValidators.isEmpty()) {
                return defaultValidator;
            }
            ArrayList<Object> validators = new ArrayList<Object>();
            validators.add(defaultValidator);
            if (!CollectionUtils.isEmpty(audiences)) {
                validators.add(this.audValidator(audiences));
            }
            validators.addAll(this.additionalValidators);
            return new DelegatingOAuth2TokenValidator(validators);
        }

        private JwtClaimValidator<List<String>> audValidator(List<String> audiences) {
            return new JwtClaimValidator("aud", aud -> this.nullSafeDisjoint((List<String>)aud, audiences));
        }

        private boolean nullSafeDisjoint(List<String> c1, List<String> c2) {
            return c1 != null && !Collections.disjoint(c1, c2);
        }

        @Bean
        @Conditional(value={KeyValueCondition.class})
        JwtDecoder jwtDecoderByPublicKeyValue() throws Exception {
            RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(this.getKeySpec(this.properties.readPublicKey())));
            NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withPublicKey((RSAPublicKey)publicKey).signatureAlgorithm(SignatureAlgorithm.from((String)this.exactlyOneAlgorithm())).build();
            jwtDecoder.setJwtValidator(this.getValidators((OAuth2TokenValidator<Jwt>)JwtValidators.createDefault()));
            return jwtDecoder;
        }

        private byte[] getKeySpec(String keyValue) {
            keyValue = keyValue.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            return Base64.getMimeDecoder().decode(keyValue);
        }

        private String exactlyOneAlgorithm() {
            int count;
            List<String> algorithms = this.properties.getJwsAlgorithms();
            int n = count = algorithms != null ? algorithms.size() : 0;
            if (count != 1) {
                throw new IllegalStateException("Creating a JWT decoder using a public key requires exactly one JWS algorithm but " + count + " were configured");
            }
            return algorithms.get(0);
        }

        @Bean
        @Conditional(value={IssuerUriCondition.class})
        SupplierJwtDecoder jwtDecoderByIssuerUri(ObjectProvider<JwkSetUriJwtDecoderBuilderCustomizer> customizers) {
            return new SupplierJwtDecoder(() -> {
                String issuerUri = this.properties.getIssuerUri();
                NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder builder = NimbusJwtDecoder.withIssuerLocation((String)issuerUri);
                customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
                NimbusJwtDecoder jwtDecoder = builder.build();
                jwtDecoder.setJwtValidator(this.getValidators((OAuth2TokenValidator<Jwt>)JwtValidators.createDefaultWithIssuer((String)issuerUri)));
                return jwtDecoder;
            });
        }
    }
}

