/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.FilteringSpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Order(value=-2147483648)
class OnClassCondition
extends FilteringSpringBootCondition {
    OnClassCondition() {
    }

    @Override
    protected final @Nullable ConditionOutcome[] getOutcomes(@Nullable String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        if (autoConfigurationClasses.length > 1 && Runtime.getRuntime().availableProcessors() > 1) {
            return this.resolveOutcomesThreaded(autoConfigurationClasses, autoConfigurationMetadata);
        }
        StandardOutcomesResolver outcomesResolver = new StandardOutcomesResolver(autoConfigurationClasses, 0, autoConfigurationClasses.length, autoConfigurationMetadata, this.getBeanClassLoader());
        return outcomesResolver.resolveOutcomes();
    }

    private @Nullable ConditionOutcome[] resolveOutcomesThreaded(@Nullable String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        int split = autoConfigurationClasses.length / 2;
        OutcomesResolver firstHalfResolver = this.createOutcomesResolver(autoConfigurationClasses, 0, split, autoConfigurationMetadata);
        StandardOutcomesResolver secondHalfResolver = new StandardOutcomesResolver(autoConfigurationClasses, split, autoConfigurationClasses.length, autoConfigurationMetadata, this.getBeanClassLoader());
        @Nullable ConditionOutcome[] secondHalf = secondHalfResolver.resolveOutcomes();
        @Nullable ConditionOutcome[] firstHalf = firstHalfResolver.resolveOutcomes();
        @Nullable ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        System.arraycopy(firstHalf, 0, outcomes, 0, firstHalf.length);
        System.arraycopy(secondHalf, 0, outcomes, split, secondHalf.length);
        return outcomes;
    }

    private OutcomesResolver createOutcomesResolver(@Nullable String[] autoConfigurationClasses, int start, int end, AutoConfigurationMetadata autoConfigurationMetadata) {
        StandardOutcomesResolver outcomesResolver = new StandardOutcomesResolver(autoConfigurationClasses, start, end, autoConfigurationMetadata, this.getBeanClassLoader());
        return new ThreadedOutcomesResolver(outcomesResolver);
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<String> onMissingClasses;
        ClassLoader classLoader = context.getClassLoader();
        ConditionMessage matchMessage = ConditionMessage.empty();
        List<String> onClasses = this.getCandidates(metadata, ConditionalOnClass.class);
        if (onClasses != null) {
            List<String> missing = this.filter(onClasses, FilteringSpringBootCondition.ClassNameFilter.MISSING, classLoader);
            if (!missing.isEmpty()) {
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnClass.class, new Object[0]).didNotFind("required class", "required classes").items(ConditionMessage.Style.QUOTE, missing));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnClass.class, new Object[0]).found("required class", "required classes").items(ConditionMessage.Style.QUOTE, this.filter(onClasses, FilteringSpringBootCondition.ClassNameFilter.PRESENT, classLoader));
        }
        if ((onMissingClasses = this.getCandidates(metadata, ConditionalOnMissingClass.class)) != null) {
            List<String> present = this.filter(onMissingClasses, FilteringSpringBootCondition.ClassNameFilter.PRESENT, classLoader);
            if (!present.isEmpty()) {
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnMissingClass.class, new Object[0]).found("unwanted class", "unwanted classes").items(ConditionMessage.Style.QUOTE, present));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnMissingClass.class, new Object[0]).didNotFind("unwanted class", "unwanted classes").items(ConditionMessage.Style.QUOTE, this.filter(onMissingClasses, FilteringSpringBootCondition.ClassNameFilter.MISSING, classLoader));
        }
        return ConditionOutcome.match(matchMessage);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable List<String> getCandidates(AnnotatedTypeMetadata metadata, Class<?> annotationType) {
        @Nullable MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
        if (attributes == null) {
            return null;
        }
        ArrayList<String> candidates = new ArrayList<String>();
        this.addAll(candidates, (List)attributes.get((Object)"value"));
        this.addAll(candidates, (List)attributes.get((Object)"name"));
        return candidates;
    }

    private void addAll(List<String> list, @Nullable List<@Nullable Object> itemsToAdd) {
        if (itemsToAdd != null) {
            for (Object item : itemsToAdd) {
                Collections.addAll(list, (String[])item);
            }
        }
    }

    private static final class StandardOutcomesResolver
    implements OutcomesResolver {
        private final @Nullable String[] autoConfigurationClasses;
        private final int start;
        private final int end;
        private final AutoConfigurationMetadata autoConfigurationMetadata;
        private final ClassLoader beanClassLoader;

        private StandardOutcomesResolver(@Nullable String[] autoConfigurationClasses, int start, int end, AutoConfigurationMetadata autoConfigurationMetadata, ClassLoader beanClassLoader) {
            this.autoConfigurationClasses = autoConfigurationClasses;
            this.start = start;
            this.end = end;
            this.autoConfigurationMetadata = autoConfigurationMetadata;
            this.beanClassLoader = beanClassLoader;
        }

        @Override
        public @Nullable ConditionOutcome[] resolveOutcomes() {
            return this.getOutcomes(this.autoConfigurationClasses, this.start, this.end, this.autoConfigurationMetadata);
        }

        private @Nullable ConditionOutcome[] getOutcomes(@Nullable String[] autoConfigurationClasses, int start, int end, AutoConfigurationMetadata autoConfigurationMetadata) {
            @Nullable ConditionOutcome[] outcomes = new ConditionOutcome[end - start];
            for (int i = start; i < end; ++i) {
                String candidates;
                String autoConfigurationClass = autoConfigurationClasses[i];
                if (autoConfigurationClass == null || (candidates = autoConfigurationMetadata.get(autoConfigurationClass, "ConditionalOnClass")) == null) continue;
                outcomes[i - start] = this.getOutcome(candidates);
            }
            return outcomes;
        }

        private @Nullable ConditionOutcome getOutcome(String candidates) {
            try {
                if (!candidates.contains(",")) {
                    return this.getOutcome(candidates, this.beanClassLoader);
                }
                for (String candidate : StringUtils.commaDelimitedListToStringArray((String)candidates)) {
                    ConditionOutcome outcome = this.getOutcome(candidate, this.beanClassLoader);
                    if (outcome == null) continue;
                    return outcome;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private @Nullable ConditionOutcome getOutcome(String className, ClassLoader classLoader) {
            if (FilteringSpringBootCondition.ClassNameFilter.MISSING.matches(className, classLoader)) {
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnClass.class, new Object[0]).didNotFind("required class").items(ConditionMessage.Style.QUOTE, className));
            }
            return null;
        }
    }

    private static interface OutcomesResolver {
        public @Nullable ConditionOutcome[] resolveOutcomes();
    }

    private static final class ThreadedOutcomesResolver
    implements OutcomesResolver {
        private final Thread thread = new Thread(() -> {
            try {
                this.outcomes = outcomesResolver.resolveOutcomes();
            }
            catch (Throwable ex) {
                this.failure = ex;
            }
        });
        private volatile @Nullable ConditionOutcome @Nullable [] outcomes;
        private volatile @Nullable Throwable failure;

        private ThreadedOutcomesResolver(OutcomesResolver outcomesResolver) {
            this.thread.start();
        }

        @Override
        public @Nullable ConditionOutcome[] resolveOutcomes() {
            ConditionOutcome[] outcomes;
            try {
                this.thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            Throwable failure = this.failure;
            if (failure != null) {
                ReflectionUtils.rethrowRuntimeException((Throwable)failure);
            }
            return (outcomes = this.outcomes) != null ? outcomes : new ConditionOutcome[]{};
        }
    }
}

