/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.buildpack.platform.docker.type.Regex;
import org.springframework.util.Assert;

public class ImageName {
    private static final Pattern PATTERN = Regex.IMAGE_NAME.compile();
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String OFFICIAL_REPOSITORY_NAME = "library";
    private static final String LEGACY_DOMAIN = "index.docker.io";
    private final String domain;
    private final String name;
    private final String string;

    ImageName(String domain, String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.domain = this.getDomainOrDefault(domain);
        this.name = this.getNameWithDefaultPath(this.domain, path);
        this.string = this.domain + "/" + this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageName other = (ImageName)obj;
        boolean result = true;
        result = result && this.domain.equals(other.domain);
        result = result && this.name.equals(other.name);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return this.string;
    }

    public String toLegacyString() {
        if (DEFAULT_DOMAIN.equals(this.domain)) {
            return "index.docker.io/" + this.name;
        }
        return this.string;
    }

    private String getDomainOrDefault(String domain) {
        if (domain == null || LEGACY_DOMAIN.equals(domain)) {
            return DEFAULT_DOMAIN;
        }
        return domain;
    }

    private String getNameWithDefaultPath(String domain, String name) {
        if (DEFAULT_DOMAIN.equals(domain) && !name.contains("/")) {
            return "library/" + name;
        }
        return name;
    }

    public static ImageName of(String value) {
        Assert.hasText((String)value, (String)"Value must not be empty");
        Matcher matcher = PATTERN.matcher(value);
        Assert.isTrue((boolean)matcher.matches(), () -> "Unable to parse name \"" + value + "\". Image name must be in the form '[domainHost:port/][path/]name', with 'path' and 'name' containing only [a-z0-9][.][_][-]");
        return new ImageName(matcher.group("domain"), matcher.group("path"));
    }
}

