/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildOwner;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.BuilderMetadata;
import org.springframework.boot.buildpack.platform.build.EphemeralBuilder;
import org.springframework.boot.buildpack.platform.build.ImageType;
import org.springframework.boot.buildpack.platform.build.Lifecycle;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.build.StackId;
import org.springframework.boot.buildpack.platform.docker.DockerApi;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressPullListener;
import org.springframework.boot.buildpack.platform.docker.TotalProgressPushListener;
import org.springframework.boot.buildpack.platform.docker.UpdateListener;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Builder {
    private final BuildLog log;
    private final DockerApi docker;
    private final DockerConfiguration dockerConfiguration;

    public Builder() {
        this(BuildLog.toSystemOut());
    }

    public Builder(DockerConfiguration dockerConfiguration) {
        this(BuildLog.toSystemOut(), dockerConfiguration);
    }

    public Builder(BuildLog log) {
        this(log, new DockerApi(), null);
    }

    public Builder(BuildLog log, DockerConfiguration dockerConfiguration) {
        this(log, new DockerApi(dockerConfiguration), dockerConfiguration);
    }

    Builder(BuildLog log, DockerApi docker, DockerConfiguration dockerConfiguration) {
        Assert.notNull((Object)log, (String)"Log must not be null");
        this.log = log;
        this.docker = docker;
        this.dockerConfiguration = dockerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(BuildRequest request) throws DockerEngineException, IOException {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.log.start(request);
        Image builderImage = this.getImage(request, ImageType.BUILDER);
        BuilderMetadata builderMetadata = BuilderMetadata.fromImage(builderImage);
        BuildOwner buildOwner = BuildOwner.fromEnv(builderImage.getConfig().getEnv());
        request = this.determineRunImage(request, builderImage, builderMetadata.getStack());
        EphemeralBuilder builder = new EphemeralBuilder(buildOwner, builderImage, builderMetadata, request.getCreator(), request.getEnv());
        this.docker.image().load(builder.getArchive(), UpdateListener.none());
        try {
            this.executeLifecycle(request, builder);
            if (request.isPublish()) {
                this.pushImage(request.getName());
            }
        }
        finally {
            this.docker.image().remove(builder.getName(), true);
        }
    }

    private BuildRequest determineRunImage(BuildRequest request, Image builderImage, BuilderMetadata.Stack builderStack) throws IOException {
        Object runImage;
        if (request.getRunImage() == null) {
            runImage = this.getRunImageReferenceForStack(builderStack);
            request = request.withRunImage((ImageReference)runImage);
        }
        runImage = this.getImage(request, ImageType.RUNNER);
        this.assertStackIdsMatch((Image)runImage, builderImage);
        return request;
    }

    private ImageReference getRunImageReferenceForStack(BuilderMetadata.Stack stack) {
        String name = stack.getRunImage().getImage();
        Assert.state((boolean)StringUtils.hasText((String)name), (String)"Run image must be specified in the builder image stack");
        return ImageReference.of(name).inTaggedOrDigestForm();
    }

    private Image getImage(BuildRequest request, ImageType imageType) throws IOException {
        ImageReference imageReference;
        ImageReference imageReference2 = imageReference = imageType == ImageType.BUILDER ? request.getBuilder() : request.getRunImage();
        if (request.getPullPolicy() == PullPolicy.ALWAYS) {
            return this.pullImage(imageReference, imageType);
        }
        try {
            return this.docker.image().inspect(imageReference);
        }
        catch (DockerEngineException exception) {
            if (request.getPullPolicy() == PullPolicy.IF_NOT_PRESENT && exception.getStatusCode() == 404) {
                return this.pullImage(imageReference, imageType);
            }
            throw exception;
        }
    }

    private Image pullImage(ImageReference reference, ImageType imageType) throws IOException {
        Consumer<TotalProgressEvent> progressConsumer = this.log.pullingImage(reference, imageType);
        TotalProgressPullListener listener = new TotalProgressPullListener(progressConsumer);
        Image image = this.docker.image().pull(reference, listener, this.getBuilderAuthHeader());
        this.log.pulledImage(image, imageType);
        return image;
    }

    private void pushImage(ImageReference reference) throws IOException {
        Consumer<TotalProgressEvent> progressConsumer = this.log.pushingImage(reference);
        TotalProgressPushListener listener = new TotalProgressPushListener(progressConsumer);
        this.docker.image().push(reference, listener, this.getPublishAuthHeader());
        this.log.pushedImage(reference);
    }

    private String getBuilderAuthHeader() {
        return this.dockerConfiguration != null && this.dockerConfiguration.getBuilderRegistryAuthentication() != null ? this.dockerConfiguration.getBuilderRegistryAuthentication().getAuthHeader() : null;
    }

    private String getPublishAuthHeader() {
        return this.dockerConfiguration != null && this.dockerConfiguration.getPublishRegistryAuthentication() != null ? this.dockerConfiguration.getPublishRegistryAuthentication().getAuthHeader() : null;
    }

    private void assertStackIdsMatch(Image runImage, Image builderImage) {
        StackId runImageStackId = StackId.fromImage(runImage);
        StackId builderImageStackId = StackId.fromImage(builderImage);
        Assert.state((boolean)runImageStackId.equals(builderImageStackId), () -> "Run image stack '" + runImageStackId + "' does not match builder stack '" + builderImageStackId + "'");
    }

    private void executeLifecycle(BuildRequest request, EphemeralBuilder builder) throws IOException {
        try (Lifecycle lifecycle = new Lifecycle(this.log, this.docker, request, builder);){
            lifecycle.execute();
        }
    }
}

