/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import com.sun.jna.Platform;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.transport.HttpClientTransport;
import org.springframework.boot.buildpack.platform.socket.DomainSocket;
import org.springframework.boot.buildpack.platform.socket.NamedPipeSocket;

final class LocalHttpClientTransport
extends HttpClientTransport {
    private static final String DOCKER_SCHEME = "docker";
    private static final int DEFAULT_DOCKER_PORT = 2376;
    private static final HttpHost LOCAL_DOCKER_HOST = new HttpHost("docker", "localhost", 2376);

    private LocalHttpClientTransport(HttpClient client, HttpHost host) {
        super(client, host);
    }

    static LocalHttpClientTransport create(ResolvedDockerHost dockerHost) {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)new LocalConnectionManager(dockerHost.getAddress()));
        builder.setRoutePlanner((HttpRoutePlanner)new LocalRoutePlanner());
        HttpHost host = new HttpHost(DOCKER_SCHEME, dockerHost.getAddress());
        return new LocalHttpClientTransport((HttpClient)builder.build(), host);
    }

    private static class LocalConnectionManager
    extends BasicHttpClientConnectionManager {
        private static final ConnectionConfig CONNECTION_CONFIG = ConnectionConfig.copy((ConnectionConfig)ConnectionConfig.DEFAULT).setValidateAfterInactivity(TimeValue.NEG_ONE_MILLISECOND).build();

        LocalConnectionManager(String host) {
            super(LocalConnectionManager.getRegistry(host), null, null, (DnsResolver)new LocalDnsResolver());
            this.setConnectionConfig(CONNECTION_CONFIG);
        }

        private static Registry<ConnectionSocketFactory> getRegistry(String host) {
            RegistryBuilder builder = RegistryBuilder.create();
            builder.register(LocalHttpClientTransport.DOCKER_SCHEME, (Object)new LocalConnectionSocketFactory(host));
            return builder.build();
        }
    }

    private static final class LocalRoutePlanner
    implements HttpRoutePlanner {
        private LocalRoutePlanner() {
        }

        public HttpRoute determineRoute(HttpHost target, HttpContext context) {
            return new HttpRoute(LOCAL_DOCKER_HOST);
        }
    }

    private static class LocalConnectionSocketFactory
    implements ConnectionSocketFactory {
        private final String host;

        LocalConnectionSocketFactory(String host) {
            this.host = host;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            if (Platform.isWindows()) {
                return NamedPipeSocket.get(this.host);
            }
            return DomainSocket.get(this.host);
        }

        public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            return socket;
        }
    }

    private static final class LocalDnsResolver
    implements DnsResolver {
        private static final InetAddress LOOPBACK = InetAddress.getLoopbackAddress();

        private LocalDnsResolver() {
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            return new InetAddress[]{LOOPBACK};
        }

        public String resolveCanonicalHostname(String host) throws UnknownHostException {
            return LOOPBACK.getCanonicalHostName();
        }
    }
}

