/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.Map;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class BuildOwner
implements Owner {
    private static final String USER_PROPERTY_NAME = "CNB_USER_ID";
    private static final String GROUP_PROPERTY_NAME = "CNB_GROUP_ID";
    private final long uid;
    private final long gid;

    BuildOwner(Map<String, String> env) {
        this.uid = this.getValue(env, USER_PROPERTY_NAME);
        this.gid = this.getValue(env, GROUP_PROPERTY_NAME);
    }

    BuildOwner(long uid, long gid) {
        this.uid = uid;
        this.gid = gid;
    }

    private long getValue(Map<String, String> env, String name) {
        String value = env.get(name);
        Assert.state((boolean)StringUtils.hasText((String)value), () -> "Missing '" + name + "' value from the builder environment '" + env + "'");
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Malformed '" + name + "' value '" + value + "' in the builder environment '" + env + "'", ex);
        }
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    @Override
    public long getGid() {
        return this.gid;
    }

    public String toString() {
        return this.uid + "/" + this.gid;
    }

    static BuildOwner fromEnv(Map<String, String> env) {
        Assert.notNull(env, (String)"'env' must not be null");
        return new BuildOwner(env);
    }

    static BuildOwner of(long uid, long gid) {
        return new BuildOwner(uid, gid);
    }
}

