/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.zip.GZIPInputStream;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.Layout;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarLayoutWriter;
import org.springframework.boot.buildpack.platform.io.ZipFileTarArchive;
import org.springframework.util.StreamUtils;
import org.springframework.util.function.ThrowingFunction;

@FunctionalInterface
public interface TarArchive {
    public static final Instant NORMALIZED_TIME = OffsetDateTime.of(1980, 1, 1, 0, 0, 1, 0, ZoneOffset.UTC).toInstant();

    public void writeTo(OutputStream var1) throws IOException;

    default public Compression getCompression() {
        return Compression.NONE;
    }

    public static TarArchive of(IOConsumer<Layout> layout) {
        return outputStream -> {
            TarLayoutWriter writer = new TarLayoutWriter(outputStream);
            layout.accept(writer);
            writer.finish();
        };
    }

    public static TarArchive fromZip(File zip, Owner owner) {
        return new ZipFileTarArchive(zip, owner);
    }

    public static TarArchive fromInputStream(final InputStream inputStream, final Compression compression) {
        return new TarArchive(){

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                StreamUtils.copy((InputStream)compression.uncompress(inputStream), (OutputStream)outputStream);
            }

            @Override
            public Compression getCompression() {
                return compression;
            }
        };
    }

    public static enum Compression {
        NONE((ThrowingFunction<InputStream, InputStream>)((ThrowingFunction)inputStream -> inputStream)),
        GZIP((ThrowingFunction<InputStream, InputStream>)((ThrowingFunction)GZIPInputStream::new)),
        ZSTD("zstd compression is not supported");

        private final ThrowingFunction<InputStream, InputStream> uncompressor;

        private Compression(String uncompressError) {
            this((ThrowingFunction<InputStream, InputStream>)((ThrowingFunction)inputStream -> {
                throw new IllegalStateException(uncompressError);
            }));
        }

        private Compression(ThrowingFunction<InputStream, InputStream> wrapper) {
            this.uncompressor = wrapper;
        }

        InputStream uncompress(InputStream inputStream) {
            return (InputStream)this.uncompressor.apply((Object)inputStream);
        }
    }
}

