/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.UpdateEvent;

public abstract class ProgressUpdateEvent
extends UpdateEvent {
    private final @Nullable String status;
    private final @Nullable ProgressDetail progressDetail;
    private final @Nullable String progress;

    protected ProgressUpdateEvent(@Nullable String status, @Nullable ProgressDetail progressDetail, @Nullable String progress) {
        this.status = status;
        this.progressDetail = ProgressDetail.isEmpty(progressDetail) ? null : progressDetail;
        this.progress = progress;
    }

    public @Nullable String getStatus() {
        return this.status;
    }

    public @Nullable ProgressDetail getProgressDetail() {
        return this.progressDetail;
    }

    public @Nullable String getProgress() {
        return this.progress;
    }

    public static class ProgressDetail {
        private final @Nullable Long current;
        private final @Nullable Long total;

        @JsonCreator
        public ProgressDetail(@Nullable Long current, @Nullable Long total) {
            this.current = current;
            this.total = total;
        }

        public int asPercentage() {
            if (this.total == null || this.current == null) {
                return 0;
            }
            int percentage = (int)(100.0 / (double)this.total.longValue() * (double)this.current.longValue());
            return percentage < 0 ? 0 : Math.min(percentage, 100);
        }

        private static boolean isEmpty(@Nullable ProgressDetail progressDetail) {
            return progressDetail == null || progressDetail.current == null || progressDetail.total == null;
        }
    }
}

