/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

class TypeElementMembers {
    private static final String OBJECT_CLASS_NAME = Object.class.getName();
    private final ProcessingEnvironment env;
    private final Map<String, VariableElement> fields = new LinkedHashMap<String, VariableElement>();
    private final Map<String, ExecutableElement> publicGetters = new LinkedHashMap<String, ExecutableElement>();
    private final Map<String, ExecutableElement> publicSetters = new LinkedHashMap<String, ExecutableElement>();

    public TypeElementMembers(ProcessingEnvironment env, TypeElement element) {
        this.env = env;
        this.process(element);
    }

    private void process(TypeElement element) {
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            this.processMethod(method);
        }
        for (VariableElement field : ElementFilter.fieldsIn(element.getEnclosedElements())) {
            this.processField(field);
        }
        Element superType = this.env.getTypeUtils().asElement(element.getSuperclass());
        if (superType != null && superType instanceof TypeElement && !OBJECT_CLASS_NAME.equals(superType.toString())) {
            this.process((TypeElement)superType);
        }
    }

    private void processMethod(ExecutableElement method) {
        if (method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            String name = method.getSimpleName().toString();
            if (this.isGetter(method) && !this.publicGetters.containsKey(name)) {
                this.publicGetters.put(this.getAccessorName(name), method);
            } else if (this.isSetter(method) && !this.publicSetters.containsKey(name)) {
                this.publicSetters.put(this.getAccessorName(name), method);
            }
        }
    }

    private boolean isGetter(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return (name.startsWith("get") || name.startsWith("is")) && method.getParameters().isEmpty() && TypeKind.VOID != method.getReturnType().getKind();
    }

    private boolean isSetter(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return name.startsWith("set") && method.getParameters().size() == 1 && this.isSetterReturnType(method);
    }

    private boolean isSetterReturnType(ExecutableElement method) {
        return TypeKind.VOID == method.getReturnType().getKind() || this.env.getTypeUtils().isSameType(method.getEnclosingElement().asType(), method.getReturnType());
    }

    private String getAccessorName(String methodName) {
        String name = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return name;
    }

    private void processField(VariableElement field) {
        String name = field.getSimpleName().toString();
        if (!this.fields.containsKey(name)) {
            this.fields.put(name, field);
        }
    }

    public Map<String, VariableElement> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public Map<String, ExecutableElement> getPublicGetters() {
        return Collections.unmodifiableMap(this.publicGetters);
    }

    public Map<String, ExecutableElement> getPublicSetters() {
        return Collections.unmodifiableMap(this.publicSetters);
    }
}

