/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

class TypeUtils {
    private static final Map<TypeKind, Class<?>> PRIMITIVE_WRAPPERS;
    private static final Map<String, TypeKind> WRAPPER_TO_PRIMITIVE;
    private final ProcessingEnvironment env;
    private final Types types;
    private final TypeExtractor typeExtractor;
    private final TypeMirror collectionType;
    private final TypeMirror mapType;
    private final Map<TypeElement, TypeDescriptor> typeDescriptors = new HashMap<TypeElement, TypeDescriptor>();

    TypeUtils(ProcessingEnvironment env) {
        this.env = env;
        this.types = env.getTypeUtils();
        this.typeExtractor = new TypeExtractor(this.types);
        this.collectionType = this.getDeclaredType(this.types, Collection.class, 1);
        this.mapType = this.getDeclaredType(this.types, Map.class, 2);
    }

    private TypeMirror getDeclaredType(Types types, Class<?> typeClass, int numberOfTypeArgs) {
        TypeMirror[] typeArgs = new TypeMirror[numberOfTypeArgs];
        Arrays.setAll(typeArgs, i -> types.getWildcardType(null, null));
        TypeElement typeElement = this.env.getElementUtils().getTypeElement(typeClass.getName());
        try {
            return types.getDeclaredType(typeElement, typeArgs);
        }
        catch (IllegalArgumentException ex) {
            return types.getDeclaredType(typeElement, new TypeMirror[0]);
        }
    }

    boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.types.isSameType(t1, t2);
    }

    Element asElement(TypeMirror type) {
        return this.types.asElement(type);
    }

    String getQualifiedName(Element element) {
        return this.typeExtractor.getQualifiedName(element);
    }

    String getType(TypeElement element, TypeMirror type) {
        if (type == null) {
            return null;
        }
        return type.accept(this.typeExtractor, this.resolveTypeDescriptor(element));
    }

    TypeMirror extractElementType(TypeMirror type) {
        if (!this.env.getTypeUtils().isAssignable(type, this.collectionType)) {
            return null;
        }
        return this.getCollectionElementType(type);
    }

    private TypeMirror getCollectionElementType(TypeMirror type) {
        if (((TypeElement)this.types.asElement(type)).getQualifiedName().contentEquals(Collection.class.getName())) {
            DeclaredType declaredType = (DeclaredType)type;
            if (declaredType.getTypeArguments().isEmpty()) {
                return this.types.getDeclaredType(this.env.getElementUtils().getTypeElement(Object.class.getName()), new TypeMirror[0]);
            }
            return declaredType.getTypeArguments().get(0);
        }
        for (TypeMirror typeMirror : this.env.getTypeUtils().directSupertypes(type)) {
            if (!this.types.isAssignable(typeMirror, this.collectionType)) continue;
            return this.getCollectionElementType(typeMirror);
        }
        return null;
    }

    boolean isCollectionOrMap(TypeMirror type) {
        return this.env.getTypeUtils().isAssignable(type, this.collectionType) || this.env.getTypeUtils().isAssignable(type, this.mapType);
    }

    String getJavaDoc(Element element) {
        if (element instanceof RecordComponentElement) {
            return this.getJavaDoc((RecordComponentElement)element);
        }
        String javadoc = element != null ? this.env.getElementUtils().getDocComment(element) : null;
        javadoc = javadoc != null ? this.cleanUpJavaDoc(javadoc) : null;
        return javadoc == null || javadoc.isEmpty() ? null : javadoc;
    }

    PrimitiveType getPrimitiveType(TypeMirror typeMirror) {
        if (this.getPrimitiveFor(typeMirror) != null) {
            return this.types.unboxedType(typeMirror);
        }
        return null;
    }

    TypeMirror getWrapperOrPrimitiveFor(TypeMirror typeMirror) {
        Class<?> candidate = this.getWrapperFor(typeMirror);
        if (candidate != null) {
            return this.env.getElementUtils().getTypeElement(candidate.getName()).asType();
        }
        TypeKind primitiveKind = this.getPrimitiveFor(typeMirror);
        if (primitiveKind != null) {
            return this.env.getTypeUtils().getPrimitiveType(primitiveKind);
        }
        return null;
    }

    private Class<?> getWrapperFor(TypeMirror type) {
        return PRIMITIVE_WRAPPERS.get((Object)type.getKind());
    }

    private TypeKind getPrimitiveFor(TypeMirror type) {
        return WRAPPER_TO_PRIMITIVE.get(type.toString());
    }

    private TypeDescriptor resolveTypeDescriptor(TypeElement element) {
        if (this.typeDescriptors.containsKey(element)) {
            return this.typeDescriptors.get(element);
        }
        return this.createTypeDescriptor(element);
    }

    private TypeDescriptor createTypeDescriptor(TypeElement element) {
        TypeDescriptor descriptor = new TypeDescriptor();
        this.process(descriptor, element.asType());
        this.typeDescriptors.put(element, descriptor);
        return descriptor;
    }

    private void process(TypeDescriptor descriptor, TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            DeclaredType freshType = (DeclaredType)this.env.getElementUtils().getTypeElement(this.types.asElement(type).toString()).asType();
            List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
            for (int i = 0; i < arguments.size(); ++i) {
                TypeMirror specificType = arguments.get(i);
                TypeMirror signatureType = freshType.getTypeArguments().get(i);
                descriptor.registerIfNecessary(signatureType, specificType);
            }
            TypeElement element = (TypeElement)this.types.asElement(type);
            this.process(descriptor, element.getSuperclass());
        }
    }

    private String getJavaDoc(RecordComponentElement recordComponent) {
        Pattern paramJavadocPattern;
        Matcher paramJavadocMatcher;
        String recordJavadoc = this.env.getElementUtils().getDocComment(recordComponent.getEnclosingElement());
        if (recordJavadoc != null && (paramJavadocMatcher = (paramJavadocPattern = this.paramJavadocPattern(recordComponent.getSimpleName().toString())).matcher(recordJavadoc)).find()) {
            String paramJavadoc = this.cleanUpJavaDoc(paramJavadocMatcher.group());
            return paramJavadoc.isEmpty() ? null : paramJavadoc;
        }
        return null;
    }

    private Pattern paramJavadocPattern(String paramName) {
        String pattern = String.format("(?<=@param +%s).*?(?=([\r\n]+ *@)|$)", paramName);
        return Pattern.compile(pattern, 32);
    }

    private String cleanUpJavaDoc(String javadoc) {
        StringBuilder result = new StringBuilder(javadoc.length());
        int lastChar = 46;
        for (int i = 0; i < javadoc.length(); ++i) {
            boolean repeatedSpace;
            char ch = javadoc.charAt(i);
            boolean bl = repeatedSpace = ch == ' ' && lastChar == 32;
            if (ch == '\r' || ch == '\n' || repeatedSpace) continue;
            result.append(ch);
            lastChar = ch;
        }
        return result.toString().trim();
    }

    static {
        EnumMap<TypeKind, Class> wrappers = new EnumMap<TypeKind, Class>(TypeKind.class);
        wrappers.put(TypeKind.BOOLEAN, Boolean.class);
        wrappers.put(TypeKind.BYTE, Byte.class);
        wrappers.put(TypeKind.CHAR, Character.class);
        wrappers.put(TypeKind.DOUBLE, Double.class);
        wrappers.put(TypeKind.FLOAT, Float.class);
        wrappers.put(TypeKind.INT, Integer.class);
        wrappers.put(TypeKind.LONG, Long.class);
        wrappers.put(TypeKind.SHORT, Short.class);
        PRIMITIVE_WRAPPERS = Collections.unmodifiableMap(wrappers);
        HashMap<String, TypeKind> primitives = new HashMap<String, TypeKind>();
        PRIMITIVE_WRAPPERS.forEach((kind, wrapperClass) -> primitives.put(wrapperClass.getName(), (TypeKind)((Object)kind)));
        WRAPPER_TO_PRIMITIVE = primitives;
    }

    private static class TypeExtractor
    extends SimpleTypeVisitor8<String, TypeDescriptor> {
        private final Types types;

        TypeExtractor(Types types) {
            this.types = types;
        }

        @Override
        public String visitDeclared(DeclaredType type, TypeDescriptor descriptor) {
            TypeElement enclosingElement = this.getEnclosingTypeElement(type);
            String qualifiedName = this.determineQualifiedName(type, enclosingElement);
            if (type.getTypeArguments().isEmpty()) {
                return qualifiedName;
            }
            StringBuilder name = new StringBuilder();
            name.append(qualifiedName);
            name.append("<").append(type.getTypeArguments().stream().map(t -> (String)this.visit((TypeMirror)t, descriptor)).collect(Collectors.joining(","))).append(">");
            return name.toString();
        }

        private String determineQualifiedName(DeclaredType type, TypeElement enclosingElement) {
            if (enclosingElement != null) {
                return this.getQualifiedName(enclosingElement) + "$" + String.valueOf(type.asElement().getSimpleName());
            }
            return this.getQualifiedName(type.asElement());
        }

        @Override
        public String visitTypeVariable(TypeVariable typeVariable, TypeDescriptor descriptor) {
            TypeMirror resolvedGeneric = descriptor.resolveGeneric(typeVariable);
            if (resolvedGeneric != null) {
                if (resolvedGeneric instanceof TypeVariable) {
                    TypeVariable resolveTypeVariable = (TypeVariable)resolvedGeneric;
                    if (!this.hasCycle(resolveTypeVariable)) {
                        return (String)this.visit(resolveTypeVariable.getUpperBound(), descriptor);
                    }
                } else {
                    return (String)this.visit(resolvedGeneric, descriptor);
                }
            }
            return this.defaultAction(typeVariable.getUpperBound(), descriptor);
        }

        private boolean hasCycle(TypeVariable variable) {
            TypeMirror upperBound = variable.getUpperBound();
            if (upperBound instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)upperBound;
                return declaredType.getTypeArguments().stream().anyMatch(candidate -> candidate.equals(variable));
            }
            return false;
        }

        @Override
        public String visitArray(ArrayType t, TypeDescriptor descriptor) {
            return t.getComponentType().accept(this, descriptor) + "[]";
        }

        @Override
        public String visitPrimitive(PrimitiveType t, TypeDescriptor descriptor) {
            return this.types.boxedClass(t).getQualifiedName().toString();
        }

        @Override
        protected String defaultAction(TypeMirror t, TypeDescriptor descriptor) {
            return t.toString();
        }

        String getQualifiedName(Element element) {
            if (element == null) {
                return null;
            }
            TypeElement enclosingElement = this.getEnclosingTypeElement(element.asType());
            if (enclosingElement != null) {
                return this.getQualifiedName(enclosingElement) + "$" + String.valueOf(((DeclaredType)element.asType()).asElement().getSimpleName());
            }
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return typeElement.getQualifiedName().toString();
            }
            throw new IllegalStateException("Could not extract qualified name from " + String.valueOf(element));
        }

        private TypeElement getEnclosingTypeElement(TypeMirror type) {
            DeclaredType declaredType;
            Element enclosingElement;
            if (type instanceof DeclaredType && (enclosingElement = (declaredType = (DeclaredType)type).asElement().getEnclosingElement()) instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)enclosingElement;
                return typeElement;
            }
            return null;
        }
    }

    static class TypeDescriptor {
        private final Map<TypeVariable, TypeMirror> generics = new HashMap<TypeVariable, TypeMirror>();

        TypeDescriptor() {
        }

        TypeMirror resolveGeneric(TypeVariable typeVariable) {
            TypeMirror resolved = this.generics.get(typeVariable);
            if (resolved != typeVariable && resolved instanceof TypeVariable) {
                TypeVariable resolvedTypeVariable = (TypeVariable)resolved;
                return this.resolveGeneric(resolvedTypeVariable);
            }
            return resolved;
        }

        private void registerIfNecessary(TypeMirror variable, TypeMirror resolution) {
            if (variable instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)variable;
                this.generics.put(typeVariable, resolution);
            }
        }
    }
}

