/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.boot.configurationprocessor.MetadataGenerationEnvironment;
import org.springframework.boot.configurationprocessor.PropertyDescriptor;

class LombokPropertyDescriptor
extends PropertyDescriptor {
    private static final String LOMBOK_DATA_ANNOTATION = "lombok.Data";
    private static final String LOMBOK_VALUE_ANNOTATION = "lombok.Value";
    private static final String LOMBOK_GETTER_ANNOTATION = "lombok.Getter";
    private static final String LOMBOK_SETTER_ANNOTATION = "lombok.Setter";
    private static final String LOMBOK_ACCESS_LEVEL_PUBLIC = "PUBLIC";
    private final ExecutableElement setter;
    private final VariableElement field;
    private final ExecutableElement factoryMethod;

    LombokPropertyDescriptor(String name, TypeMirror type, TypeElement declaringElement, ExecutableElement getter, ExecutableElement setter, VariableElement field, ExecutableElement factoryMethod) {
        super(name, type, declaringElement, getter);
        this.factoryMethod = factoryMethod;
        this.field = field;
        this.setter = setter;
    }

    VariableElement getField() {
        return this.field;
    }

    @Override
    protected boolean isMarkedAsNested(MetadataGenerationEnvironment environment) {
        return environment.getNestedConfigurationPropertyAnnotation(this.getField()) != null;
    }

    @Override
    protected String resolveDescription(MetadataGenerationEnvironment environment) {
        return environment.getTypeUtils().getJavaDoc(this.field);
    }

    @Override
    protected Object resolveDefaultValue(MetadataGenerationEnvironment environment) {
        return environment.getFieldDefaultValue(this.getDeclaringElement(), this.field);
    }

    @Override
    protected List<Element> getDeprecatableElements() {
        return Arrays.asList(this.getGetter(), this.setter, this.field, this.factoryMethod);
    }

    @Override
    public boolean isProperty(MetadataGenerationEnvironment env) {
        if (!this.hasLombokPublicAccessor(env, true)) {
            return false;
        }
        boolean isCollection = env.getTypeUtils().isCollectionOrMap(this.getType());
        return !env.isExcluded(this.getType()) && (this.hasSetter(env) || isCollection);
    }

    @Override
    public boolean isNested(MetadataGenerationEnvironment environment) {
        return this.hasLombokPublicAccessor(environment, true) && super.isNested(environment);
    }

    private boolean hasSetter(MetadataGenerationEnvironment env) {
        boolean nonFinalPublicField = !this.getField().getModifiers().contains((Object)Modifier.FINAL) && this.hasLombokPublicAccessor(env, false);
        return this.setter != null || nonFinalPublicField;
    }

    private boolean hasLombokPublicAccessor(MetadataGenerationEnvironment env, boolean getter) {
        String annotation = getter ? LOMBOK_GETTER_ANNOTATION : LOMBOK_SETTER_ANNOTATION;
        AnnotationMirror lombokMethodAnnotationOnField = env.getAnnotation(this.getField(), annotation);
        if (lombokMethodAnnotationOnField != null) {
            return this.isAccessLevelPublic(env, lombokMethodAnnotationOnField);
        }
        AnnotationMirror lombokMethodAnnotationOnElement = env.getAnnotation(this.getDeclaringElement(), annotation);
        if (lombokMethodAnnotationOnElement != null) {
            return this.isAccessLevelPublic(env, lombokMethodAnnotationOnElement);
        }
        return env.hasAnnotation(this.getDeclaringElement(), LOMBOK_DATA_ANNOTATION) || env.hasAnnotation(this.getDeclaringElement(), LOMBOK_VALUE_ANNOTATION);
    }

    private boolean isAccessLevelPublic(MetadataGenerationEnvironment env, AnnotationMirror lombokAnnotation) {
        Map<String, Object> values = env.getAnnotationElementValues(lombokAnnotation);
        Object value = values.get("value");
        return value == null || value.toString().equals(LOMBOK_ACCESS_LEVEL_PUBLIC);
    }
}

