/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.jdbc.autoconfigure;

import java.util.Optional;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.jdbc.autoconfigure.DataJdbcDatabaseDialect;
import org.springframework.boot.data.jdbc.autoconfigure.DataJdbcProperties;
import org.springframework.boot.data.jdbc.autoconfigure.DataJdbcRepositoriesRegistrar;
import org.springframework.boot.jdbc.autoconfigure.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.jdbc.autoconfigure.JdbcTemplateAutoConfiguration;
import org.springframework.boot.persistence.autoconfigure.EntityScanner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jdbc.core.JdbcAggregateTemplate;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.jdbc.core.convert.RelationResolver;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.core.mapping.JdbcMappingContext;
import org.springframework.data.jdbc.repository.config.AbstractJdbcConfiguration;
import org.springframework.data.jdbc.repository.config.JdbcRepositoryConfigExtension;
import org.springframework.data.relational.RelationalManagedTypes;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
@ConditionalOnBean(value={NamedParameterJdbcOperations.class, PlatformTransactionManager.class})
@ConditionalOnClass(value={NamedParameterJdbcOperations.class, AbstractJdbcConfiguration.class})
@ConditionalOnBooleanProperty(name={"spring.data.jdbc.repositories.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={DataJdbcProperties.class})
public final class DataJdbcRepositoriesAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={AbstractJdbcConfiguration.class})
    static class SpringBootJdbcConfiguration
    extends AbstractJdbcConfiguration {
        private final ApplicationContext applicationContext;
        private final DataJdbcProperties properties;

        SpringBootJdbcConfiguration(ApplicationContext applicationContext, DataJdbcProperties properties) {
            this.applicationContext = applicationContext;
            this.properties = properties;
        }

        protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
            return new EntityScanner(this.applicationContext).scan(new Class[]{Table.class});
        }

        @Bean
        @ConditionalOnMissingBean
        public RelationalManagedTypes jdbcManagedTypes() throws ClassNotFoundException {
            return super.jdbcManagedTypes();
        }

        @Bean
        @ConditionalOnMissingBean
        public JdbcMappingContext jdbcMappingContext(Optional<NamingStrategy> namingStrategy, JdbcCustomConversions customConversions, RelationalManagedTypes jdbcManagedTypes) {
            return super.jdbcMappingContext(namingStrategy, customConversions, jdbcManagedTypes);
        }

        @Bean
        @ConditionalOnMissingBean
        public JdbcConverter jdbcConverter(JdbcMappingContext mappingContext, NamedParameterJdbcOperations operations, @Lazy RelationResolver relationResolver, JdbcCustomConversions conversions, JdbcDialect dialect) {
            return super.jdbcConverter(mappingContext, operations, relationResolver, conversions, dialect);
        }

        @Bean
        @ConditionalOnMissingBean
        public JdbcCustomConversions jdbcCustomConversions() {
            return super.jdbcCustomConversions();
        }

        @Bean
        @ConditionalOnMissingBean
        public JdbcAggregateTemplate jdbcAggregateTemplate(ApplicationContext applicationContext, JdbcMappingContext mappingContext, JdbcConverter converter, DataAccessStrategy dataAccessStrategy) {
            return super.jdbcAggregateTemplate(applicationContext, mappingContext, converter, dataAccessStrategy);
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAccessStrategy dataAccessStrategyBean(NamedParameterJdbcOperations operations, JdbcConverter jdbcConverter, JdbcMappingContext context, JdbcDialect dialect) {
            return super.dataAccessStrategyBean(operations, jdbcConverter, context, dialect);
        }

        @Bean
        @ConditionalOnMissingBean
        public JdbcDialect jdbcDialect(NamedParameterJdbcOperations operations) {
            DataJdbcDatabaseDialect dialect = this.properties.getDialect();
            return dialect != null ? dialect.getJdbcDialect(operations.getJdbcOperations()) : super.jdbcDialect(operations);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={JdbcRepositoryConfigExtension.class})
    @Import(value={DataJdbcRepositoriesRegistrar.class})
    static class JdbcRepositoriesConfiguration {
        JdbcRepositoriesConfiguration() {
        }
    }
}

