/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnInitializedRestarterCondition
extends SpringBootCondition {
    OnInitializedRestarterCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Restarter restarter = this.getRestarter();
        if (restarter == null) {
            return ConditionOutcome.noMatch((String)"Restarter unavailable");
        }
        if (restarter.getInitialUrls() == null) {
            return ConditionOutcome.noMatch((String)"Restarter initialized without URLs");
        }
        return ConditionOutcome.match((String)"Restarter available and initialized");
    }

    private Restarter getRestarter() {
        try {
            return Restarter.getInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

