/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Conditional(value={DevToolsDataSourceCondition.class})
@Configuration
public class DevToolsDataSourceAutoConfiguration {
    @Bean
    NonEmbeddedInMemoryDatabaseShutdownExecutor inMemoryDatabaseShutdownExecutor(DataSource dataSource, DataSourceProperties dataSourceProperties) {
        return new NonEmbeddedInMemoryDatabaseShutdownExecutor(dataSource, dataSourceProperties);
    }

    static class DevToolsDataSourceCondition
    extends SpringBootCondition
    implements ConfigurationCondition {
        DevToolsDataSourceCondition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String[] dataSourceBeanNames = context.getBeanFactory().getBeanNamesForType(DataSource.class);
            if (dataSourceBeanNames.length != 1) {
                return ConditionOutcome.noMatch((String)"A single DataSource bean was not found in the context");
            }
            if (context.getBeanFactory().getBeanNamesForType(DataSourceProperties.class).length != 1) {
                return ConditionOutcome.noMatch((String)"A single DataSourceProperties bean was not found in the context");
            }
            BeanDefinition dataSourceDefinition = context.getRegistry().getBeanDefinition(dataSourceBeanNames[0]);
            if (dataSourceDefinition instanceof AnnotatedBeanDefinition && ((AnnotatedBeanDefinition)dataSourceDefinition).getFactoryMethodMetadata() != null && ((AnnotatedBeanDefinition)dataSourceDefinition).getFactoryMethodMetadata().getDeclaringClassName().startsWith(DataSourceAutoConfiguration.class.getName())) {
                return ConditionOutcome.match((String)"Found auto-configured DataSource");
            }
            return ConditionOutcome.noMatch((String)"DataSource was not auto-configured");
        }
    }

    static final class NonEmbeddedInMemoryDatabaseShutdownExecutor
    implements DisposableBean {
        private static final Set<String> IN_MEMORY_DRIVER_CLASS_NAMES = new HashSet<String>(Arrays.asList("org.apache.derby.jdbc.EmbeddedDriver", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "org.hsqldb.jdbcDriver", "org.hsqldb.jdbc.JDBCDriver", "org.hsqldb.jdbc.pool.JDBCXADataSource"));
        private final DataSource dataSource;
        private final DataSourceProperties dataSourceProperties;

        NonEmbeddedInMemoryDatabaseShutdownExecutor(DataSource dataSource, DataSourceProperties dataSourceProperties) {
            this.dataSource = dataSource;
            this.dataSourceProperties = dataSourceProperties;
        }

        public void destroy() throws Exception {
            if (this.dataSourceRequiresShutdown()) {
                this.dataSource.getConnection().createStatement().execute("SHUTDOWN");
            }
        }

        private boolean dataSourceRequiresShutdown() {
            return IN_MEMORY_DRIVER_CLASS_NAMES.contains(this.dataSourceProperties.getDriverClassName()) && !(this.dataSource instanceof EmbeddedDatabase);
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    static class DatabaseShutdownExecutorJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        DatabaseShutdownExecutorJpaDependencyConfiguration() {
            super(new String[]{"inMemoryDatabaseShutdownExecutor"});
        }
    }
}

