/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.util.List;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.devtools.restart.AgentReloader;
import org.springframework.boot.devtools.restart.DefaultRestartInitializer;
import org.springframework.boot.devtools.restart.RestartListener;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class RestartApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered {
    private int order = Integer.MIN_VALUE;
    private static final String ENABLED_PROPERTY = "spring.devtools.restart.enabled";

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartedEvent) {
            this.onApplicationStartedEvent((ApplicationStartedEvent)event);
        }
        if (event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) {
            Restarter.getInstance().finish();
        }
    }

    private void onApplicationStartedEvent(ApplicationStartedEvent event) {
        String enabled = System.getProperty(ENABLED_PROPERTY);
        if (enabled == null || Boolean.parseBoolean(enabled)) {
            String[] args = event.getArgs();
            DefaultRestartInitializer initializer = new DefaultRestartInitializer();
            boolean restartOnInitialize = !AgentReloader.isActive();
            List restartListeners = SpringFactoriesLoader.loadFactories(RestartListener.class, (ClassLoader)this.getClass().getClassLoader());
            Restarter.initialize(args, false, initializer, restartOnInitialize, restartListeners.toArray(new RestartListener[restartListeners.size()]));
        } else {
            Restarter.disable();
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

