/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.util.Assert;

class MainMethod {
    private final Method method;

    MainMethod() {
        this(Thread.currentThread());
    }

    MainMethod(Thread thread) {
        Assert.notNull((Object)thread, (String)"Thread must not be null");
        this.method = this.getMainMethod(thread);
    }

    private Method getMainMethod(Thread thread) {
        for (StackTraceElement element : thread.getStackTrace()) {
            Method method;
            if (!"main".equals(element.getMethodName()) || (method = this.getMainMethod(element)) == null) continue;
            return method;
        }
        throw new IllegalStateException("Unable to find main method");
    }

    private Method getMainMethod(StackTraceElement element) {
        try {
            Class<?> elementClass = Class.forName(element.getClassName());
            Method method = elementClass.getDeclaredMethod("main", String[].class);
            if (Modifier.isStatic(method.getModifiers())) {
                return method;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getDeclaringClassName() {
        return this.method.getDeclaringClass().getName();
    }
}

