/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.devtools.livereload.LiveReloadServer;
import org.springframework.core.log.LogMessage;

public class OptionalLiveReloadServer
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(OptionalLiveReloadServer.class);
    private LiveReloadServer server;

    public OptionalLiveReloadServer(LiveReloadServer server) {
        this.server = server;
    }

    public void afterPropertiesSet() throws Exception {
        this.startServer();
    }

    void startServer() {
        if (this.server != null) {
            try {
                int port = this.server.getPort();
                if (!this.server.isStarted()) {
                    port = this.server.start();
                }
                logger.info((Object)LogMessage.format((String)"LiveReload server is running on port %s", (Object)port));
            }
            catch (Exception ex) {
                logger.warn((Object)"Unable to start LiveReload server");
                logger.debug((Object)"Live reload start error", (Throwable)ex);
                this.server = null;
            }
        }
    }

    public void triggerReload() {
        if (this.server != null) {
            this.server.triggerReload();
        }
    }
}

