/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.sqlserver;

import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.jdbc.JdbcUrlBuilder;
import org.springframework.boot.docker.compose.service.connection.sqlserver.SqlServerEnvironment;

class SqlServerJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    protected SqlServerJdbcDockerComposeConnectionDetailsFactory() {
        super("mssql/server", new String[0]);
    }

    @Override
    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new SqlServerJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class SqlServerJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final JdbcUrlBuilder jdbcUrlBuilder = new JdbcUrlBuilder("sqlserver", 1433);
        private final SqlServerEnvironment environment;
        private final String jdbcUrl;

        SqlServerJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new SqlServerEnvironment(service.env());
            this.jdbcUrl = this.disableEncryptionIfNecessary(jdbcUrlBuilder.build(service, ""));
        }

        private String disableEncryptionIfNecessary(String jdbcUrl) {
            if (jdbcUrl.contains(";encrypt=false;")) {
                return jdbcUrl;
            }
            StringBuilder jdbcUrlBuilder = new StringBuilder(jdbcUrl);
            if (!jdbcUrl.endsWith(";")) {
                jdbcUrlBuilder.append(";");
            }
            jdbcUrlBuilder.append("encrypt=false;");
            return jdbcUrlBuilder.toString();
        }

        public String getUsername() {
            return this.environment.getUsername();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

