/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection;

import java.util.Arrays;
import java.util.function.Predicate;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.ConnectionNamePredicate;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class DockerComposeConnectionDetailsFactory<D extends ConnectionDetails>
implements ConnectionDetailsFactory<DockerComposeConnectionSource, D> {
    private final Predicate<DockerComposeConnectionSource> predicate;
    private final String[] requiredClassNames;

    protected DockerComposeConnectionDetailsFactory(String connectionName, String ... requiredClassNames) {
        this(new ConnectionNamePredicate(connectionName), requiredClassNames);
    }

    protected DockerComposeConnectionDetailsFactory(Predicate<DockerComposeConnectionSource> predicate, String ... requiredClassNames) {
        this.predicate = predicate;
        this.requiredClassNames = requiredClassNames;
    }

    public final D getConnectionDetails(DockerComposeConnectionSource source) {
        return !this.accept(source) ? null : (D)this.getDockerComposeConnectionDetails(source);
    }

    private boolean accept(DockerComposeConnectionSource source) {
        return this.hasRequiredClasses() && this.predicate.test(source);
    }

    private boolean hasRequiredClasses() {
        return ObjectUtils.isEmpty((Object[])this.requiredClassNames) || Arrays.stream(this.requiredClassNames).allMatch(requiredClassName -> ClassUtils.isPresent((String)requiredClassName, null));
    }

    protected abstract D getDockerComposeConnectionDetails(DockerComposeConnectionSource var1);

    protected static class DockerComposeConnectionDetails
    implements ConnectionDetails,
    OriginProvider {
        private final Origin origin;

        protected DockerComposeConnectionDetails(RunningService runningService) {
            Assert.notNull((Object)runningService, (String)"RunningService must not be null");
            this.origin = Origin.from((Object)runningService);
        }

        public Origin getOrigin() {
            return this.origin;
        }
    }
}

