/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.lifecycle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.AotDetector;
import org.springframework.boot.SpringApplicationShutdownHandlers;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.docker.compose.core.DockerCompose;
import org.springframework.boot.docker.compose.core.DockerComposeFile;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeProperties;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeServicesReadyEvent;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeSkipCheck;
import org.springframework.boot.docker.compose.lifecycle.LifecycleManagement;
import org.springframework.boot.docker.compose.lifecycle.ServiceReadinessChecks;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

class DockerComposeLifecycleManager {
    private static final Log logger = LogFactory.getLog(DockerComposeLifecycleManager.class);
    private static final String IGNORE_LABEL = "org.springframework.boot.ignore";
    private final File workingDirectory;
    private final ApplicationContext applicationContext;
    private final ClassLoader classLoader;
    private final SpringApplicationShutdownHandlers shutdownHandlers;
    private final DockerComposeProperties properties;
    private final Set<ApplicationListener<?>> eventListeners;
    private final DockerComposeSkipCheck skipCheck;
    private final ServiceReadinessChecks serviceReadinessChecks;

    DockerComposeLifecycleManager(ApplicationContext applicationContext, Binder binder, SpringApplicationShutdownHandlers shutdownHandlers, DockerComposeProperties properties, Set<ApplicationListener<?>> eventListeners) {
        this(null, applicationContext, binder, shutdownHandlers, properties, eventListeners, new DockerComposeSkipCheck(), null);
    }

    DockerComposeLifecycleManager(File workingDirectory, ApplicationContext applicationContext, Binder binder, SpringApplicationShutdownHandlers shutdownHandlers, DockerComposeProperties properties, Set<ApplicationListener<?>> eventListeners, DockerComposeSkipCheck skipCheck, ServiceReadinessChecks serviceReadinessChecks) {
        this.workingDirectory = workingDirectory;
        this.applicationContext = applicationContext;
        this.classLoader = applicationContext.getClassLoader();
        this.shutdownHandlers = shutdownHandlers;
        this.properties = properties;
        this.eventListeners = eventListeners;
        this.skipCheck = skipCheck;
        this.serviceReadinessChecks = serviceReadinessChecks != null ? serviceReadinessChecks : new ServiceReadinessChecks(properties.getReadiness());
    }

    void start() {
        Set<String> activeProfiles;
        if (Boolean.getBoolean("spring.aot.processing") || AotDetector.useGeneratedArtifacts()) {
            logger.trace((Object)"Docker Compose support disabled with AOT and native images");
            return;
        }
        if (!this.properties.isEnabled()) {
            logger.trace((Object)"Docker Compose support not enabled");
            return;
        }
        if (this.skipCheck.shouldSkip(this.classLoader, this.properties.getSkip())) {
            logger.trace((Object)"Docker Compose support skipped");
            return;
        }
        DockerComposeFile composeFile = this.getComposeFile();
        DockerCompose dockerCompose = this.getDockerCompose(composeFile, activeProfiles = this.properties.getProfiles().getActive());
        if (!dockerCompose.hasDefinedServices()) {
            logger.warn((Object)LogMessage.format((String)"No services defined in Docker Compose file '%s' with active profiles %s", (Object)composeFile, activeProfiles));
            return;
        }
        LifecycleManagement lifecycleManagement = this.properties.getLifecycleManagement();
        DockerComposeProperties.Start start = this.properties.getStart();
        DockerComposeProperties.Stop stop = this.properties.getStop();
        DockerComposeProperties.Readiness.Wait wait = this.properties.getReadiness().getWait();
        List<RunningService> runningServices = dockerCompose.getRunningServices();
        if (lifecycleManagement.shouldStart()) {
            if (runningServices.isEmpty()) {
                start.getCommand().applyTo(dockerCompose, start.getLogLevel());
                runningServices = dockerCompose.getRunningServices();
                if (wait == DockerComposeProperties.Readiness.Wait.ONLY_IF_STARTED) {
                    wait = DockerComposeProperties.Readiness.Wait.ALWAYS;
                }
                if (lifecycleManagement.shouldStop()) {
                    this.shutdownHandlers.add(() -> stop.getCommand().applyTo(dockerCompose, stop.getTimeout()));
                }
            } else {
                logger.info((Object)"There are already Docker Compose services running, skipping startup");
            }
        }
        ArrayList<RunningService> relevantServices = new ArrayList<RunningService>(runningServices);
        relevantServices.removeIf(this::isIgnored);
        if (wait == DockerComposeProperties.Readiness.Wait.ALWAYS || wait == null) {
            this.serviceReadinessChecks.waitUntilReady(relevantServices);
        }
        this.publishEvent(new DockerComposeServicesReadyEvent(this.applicationContext, relevantServices));
    }

    protected DockerComposeFile getComposeFile() {
        DockerComposeFile composeFile = this.properties.getFile() != null ? DockerComposeFile.of(this.properties.getFile()) : DockerComposeFile.find(this.workingDirectory);
        Assert.state((composeFile != null ? 1 : 0) != 0, () -> "No Docker Compose file found in directory '%s'".formatted((this.workingDirectory != null ? this.workingDirectory : new File(".")).toPath().toAbsolutePath()));
        logger.info((Object)LogMessage.format((String)"Using Docker Compose file '%s'", (Object)composeFile));
        return composeFile;
    }

    protected DockerCompose getDockerCompose(DockerComposeFile composeFile, Set<String> activeProfiles) {
        return DockerCompose.get(composeFile, this.properties.getHost(), activeProfiles);
    }

    private boolean isIgnored(RunningService service) {
        return service.labels().containsKey(IGNORE_LABEL);
    }

    private void publishEvent(DockerComposeServicesReadyEvent event) {
        SimpleApplicationEventMulticaster multicaster = new SimpleApplicationEventMulticaster();
        this.eventListeners.forEach(arg_0 -> ((SimpleApplicationEventMulticaster)multicaster).addApplicationListener(arg_0));
        multicaster.multicastEvent((ApplicationEvent)event);
    }
}

