/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.lifecycle;

import java.io.File;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.docker.compose.lifecycle.LifecycleManagement;
import org.springframework.boot.docker.compose.lifecycle.StartCommand;
import org.springframework.boot.docker.compose.lifecycle.StopCommand;
import org.springframework.boot.logging.LogLevel;

@ConfigurationProperties(value="spring.docker.compose")
public class DockerComposeProperties {
    static final String NAME = "spring.docker.compose";
    private boolean enabled = true;
    private File file;
    private LifecycleManagement lifecycleManagement = LifecycleManagement.START_AND_STOP;
    private String host;
    private final Start start = new Start();
    private final Stop stop = new Stop();
    private final Profiles profiles = new Profiles();
    private final Skip skip = new Skip();
    private final Readiness readiness = new Readiness();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public LifecycleManagement getLifecycleManagement() {
        return this.lifecycleManagement;
    }

    public void setLifecycleManagement(LifecycleManagement lifecycleManagement) {
        this.lifecycleManagement = lifecycleManagement;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Start getStart() {
        return this.start;
    }

    public Stop getStop() {
        return this.stop;
    }

    public Profiles getProfiles() {
        return this.profiles;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public Readiness getReadiness() {
        return this.readiness;
    }

    static DockerComposeProperties get(Binder binder) {
        return (DockerComposeProperties)binder.bind(NAME, DockerComposeProperties.class).orElseGet(DockerComposeProperties::new);
    }

    public static class Start {
        private StartCommand command = StartCommand.UP;
        private LogLevel logLevel = LogLevel.INFO;

        public StartCommand getCommand() {
            return this.command;
        }

        public void setCommand(StartCommand command) {
            this.command = command;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
        }
    }

    public static class Stop {
        private StopCommand command = StopCommand.STOP;
        private Duration timeout = Duration.ofSeconds(10L);

        public StopCommand getCommand() {
            return this.command;
        }

        public void setCommand(StopCommand command) {
            this.command = command;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }
    }

    public static class Profiles {
        private Set<String> active = new LinkedHashSet<String>();

        public Set<String> getActive() {
            return this.active;
        }

        public void setActive(Set<String> active) {
            this.active = active;
        }
    }

    public static class Skip {
        private boolean inTests = true;

        public boolean isInTests() {
            return this.inTests;
        }

        public void setInTests(boolean inTests) {
            this.inTests = inTests;
        }
    }

    public static class Readiness {
        private Wait wait = Wait.ALWAYS;
        private Duration timeout = Duration.ofMinutes(2L);
        private final Tcp tcp = new Tcp();

        public Wait getWait() {
            return this.wait;
        }

        public void setWait(Wait wait) {
            this.wait = wait;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public Tcp getTcp() {
            return this.tcp;
        }

        public static enum Wait {
            ALWAYS,
            NEVER,
            ONLY_IF_STARTED;

        }

        public static class Tcp {
            private Duration connectTimeout = Duration.ofMillis(200L);
            private Duration readTimeout = Duration.ofMillis(200L);

            public Duration getConnectTimeout() {
                return this.connectTimeout;
            }

            public void setConnectTimeout(Duration connectTimeout) {
                this.connectTimeout = connectTimeout;
            }

            public Duration getReadTimeout() {
                return this.readTimeout;
            }

            public void setReadTimeout(Duration readTimeout) {
                this.readTimeout = readTimeout;
            }
        }
    }
}

