/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.otlp;

import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class OpenTelemetryTracingDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<OtlpTracingConnectionDetails> {
    private static final int OTLP_PORT = 4318;

    OpenTelemetryTracingDockerComposeConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", "org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpAutoConfiguration");
    }

    @Override
    protected OtlpTracingConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenTelemetryTracingDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class OpenTelemetryTracingDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements OtlpTracingConnectionDetails {
        private final String host;
        private final int port;

        private OpenTelemetryTracingDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.port = source.ports().get(4318);
        }

        public String getUrl() {
            return "http://%s:%d/v1/traces".formatted(this.host, this.port);
        }
    }
}

