/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.springframework.boot.docker.compose.core.DockerOutputParseException;

final class DockerJson {
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().defaultLocale(Locale.ENGLISH)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).addModule((Module)new ParameterNamesModule())).build();

    private DockerJson() {
    }

    static <T> List<T> deserializeToList(String json, Class<T> itemType) {
        if (json.startsWith("[")) {
            CollectionType javaType = objectMapper.getTypeFactory().constructCollectionType(List.class, itemType);
            return (List)DockerJson.deserialize(json, (JavaType)javaType);
        }
        return json.trim().lines().map(line -> DockerJson.deserialize(line, itemType)).toList();
    }

    static <T> T deserialize(String json, Class<T> type) {
        return DockerJson.deserialize(json, objectMapper.getTypeFactory().constructType(type));
    }

    private static <T> T deserialize(String json, JavaType type) {
        try {
            return (T)objectMapper.readValue(json.trim(), type);
        }
        catch (IOException ex) {
            throw new DockerOutputParseException(json, ex);
        }
    }
}

