/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.elasticsearch;

import java.util.List;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.elasticsearch.ElasticsearchEnvironment;

class ElasticsearchDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<ElasticsearchConnectionDetails> {
    private static final String[] ELASTICSEARCH_CONTAINER_NAMES = new String[]{"elasticsearch", "bitnami/elasticsearch"};
    private static final int ELASTICSEARCH_PORT = 9200;

    protected ElasticsearchDockerComposeConnectionDetailsFactory() {
        super(ELASTICSEARCH_CONTAINER_NAMES, new String[0]);
    }

    @Override
    protected ElasticsearchConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ElasticsearchDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ElasticsearchDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements ElasticsearchConnectionDetails {
        private final ElasticsearchEnvironment environment;
        private final List<ElasticsearchConnectionDetails.Node> nodes;

        ElasticsearchDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new ElasticsearchEnvironment(service.env());
            this.nodes = List.of(new ElasticsearchConnectionDetails.Node(service.host(), service.ports().get(9200), ElasticsearchConnectionDetails.Node.Protocol.HTTP, this.getUsername(), this.getPassword()));
        }

        public String getUsername() {
            return "elastic";
        }

        public String getPassword() {
            return this.environment.getPassword();
        }

        public List<ElasticsearchConnectionDetails.Node> getNodes() {
            return this.nodes;
        }
    }
}

