/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.repackage;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;

class ProjectLibraries
implements Libraries {
    private final Project project;
    private final SpringBootPluginExtension extension;
    private String providedConfigurationName = "providedRuntime";
    private String customConfigurationName = null;

    public ProjectLibraries(Project project, SpringBootPluginExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public void setProvidedConfigurationName(String providedConfigurationName) {
        this.providedConfigurationName = providedConfigurationName;
    }

    public void setCustomConfigurationName(String customConfigurationName) {
        this.customConfigurationName = customConfigurationName;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Set<ResolvedArtifact> custom = this.getArtifacts(this.customConfigurationName);
        if (custom != null) {
            this.libraries(LibraryScope.CUSTOM, custom, callback);
        } else {
            Set<ResolvedArtifact> compile = this.getArtifacts("compile");
            Set<ResolvedArtifact> runtime = this.getArtifacts("runtime");
            runtime = this.minus(runtime, compile);
            Set<ResolvedArtifact> provided = this.getArtifacts(this.providedConfigurationName);
            if (provided != null) {
                compile = this.minus(compile, provided);
                runtime = this.minus(runtime, provided);
            }
            this.libraries(LibraryScope.COMPILE, compile, callback);
            this.libraries(LibraryScope.RUNTIME, runtime, callback);
            this.libraries(LibraryScope.PROVIDED, provided, callback);
        }
    }

    private Set<ResolvedArtifact> getArtifacts(String configurationName) {
        Configuration configuration = configurationName == null ? null : (Configuration)this.project.getConfigurations().findByName(configurationName);
        return configuration == null ? null : configuration.getResolvedConfiguration().getResolvedArtifacts();
    }

    private Set<ResolvedArtifact> minus(Set<ResolvedArtifact> source, Set<ResolvedArtifact> toRemove) {
        if (source == null || toRemove == null) {
            return source;
        }
        HashSet<File> filesToRemove = new HashSet<File>();
        for (ResolvedArtifact artifact : toRemove) {
            filesToRemove.add(artifact.getFile());
        }
        LinkedHashSet<ResolvedArtifact> result = new LinkedHashSet<ResolvedArtifact>();
        for (ResolvedArtifact artifact : source) {
            if (toRemove.contains(artifact.getFile())) continue;
            result.add(artifact);
        }
        return result;
    }

    private void libraries(LibraryScope scope, Set<ResolvedArtifact> artifacts, LibraryCallback callback) throws IOException {
        if (artifacts != null) {
            for (ResolvedArtifact artifact : artifacts) {
                callback.library(new Library(artifact.getFile(), scope, this.isUnpackRequired(artifact)));
            }
        }
    }

    private boolean isUnpackRequired(ResolvedArtifact artifact) {
        if (this.extension.getRequiresUnpack() != null) {
            ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
            return this.extension.getRequiresUnpack().contains(String.valueOf(id.getGroup()) + ":" + id.getName());
        }
        return false;
    }
}

