/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.repackage;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.repackage.ProjectLibraries;
import org.springframework.boot.loader.tools.Repackager;
import org.springframework.util.FileCopyUtils;

public class RepackageTask
extends DefaultTask {
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private String customConfiguration;
    private Object withJarTask;
    private String mainClass;
    private String classifier;
    private File outputFile;
    private boolean enabled = true;

    public void setCustomConfiguration(String customConfiguration) {
        this.customConfiguration = customConfiguration;
    }

    public Object getWithJarTask() {
        return this.withJarTask;
    }

    public void setWithJarTask(Object withJarTask) {
        this.withJarTask = withJarTask;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @TaskAction
    public void repackage() {
        Project project = this.getProject();
        SpringBootPluginExtension extension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        ProjectLibraries libraries = this.getLibraries();
        project.getTasks().withType(Jar.class, (Action)new RepackageAction(extension, libraries));
    }

    public ProjectLibraries getLibraries() {
        Project project = this.getProject();
        SpringBootPluginExtension extension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        ProjectLibraries libraries = new ProjectLibraries(project, extension);
        if (extension.getProvidedConfiguration() != null) {
            libraries.setProvidedConfigurationName(extension.getProvidedConfiguration());
        }
        if (this.customConfiguration != null) {
            libraries.setCustomConfigurationName(this.customConfiguration);
        } else if (extension.getCustomConfiguration() != null) {
            libraries.setCustomConfigurationName(extension.getCustomConfiguration());
        }
        return libraries;
    }

    void setOutputFile(File file) {
        this.outputFile = file;
    }

    private class LoggingRepackager
    extends Repackager {
        public LoggingRepackager(File source) {
            super(source);
        }

        protected String findMainMethod(JarFile source) throws IOException {
            long startTime = System.currentTimeMillis();
            try {
                String string = super.findMainMethod(source);
                return string;
            }
            finally {
                long duration = System.currentTimeMillis() - startTime;
                if (duration > FIND_WARNING_TIMEOUT) {
                    RepackageTask.this.getLogger().warn("Searching for the main-class is taking some time, consider using setting 'springBoot.mainClass'");
                }
            }
        }
    }

    private class RepackageAction
    implements Action<Jar> {
        private final SpringBootPluginExtension extension;
        private final ProjectLibraries libraries;

        public RepackageAction(SpringBootPluginExtension extension, ProjectLibraries libraries) {
            this.extension = extension;
            this.libraries = libraries;
        }

        public void execute(Jar jarTask) {
            File file;
            if (!RepackageTask.this.enabled) {
                RepackageTask.this.getLogger().info("Repackage disabled");
                return;
            }
            Object withJarTask = RepackageTask.this.withJarTask;
            if (this.isTaskMatch(jarTask, withJarTask)) {
                RepackageTask.this.getLogger().info("Jar task not repackaged (didn't match withJarTask): " + jarTask);
                return;
            }
            if (("".equals(jarTask.getClassifier()) || RepackageTask.this.withJarTask != null) && (file = jarTask.getArchivePath()).exists()) {
                this.repackage(file);
            }
        }

        private boolean isTaskMatch(Jar task, Object compare) {
            if (compare == null) {
                return false;
            }
            TaskContainer tasks = RepackageTask.this.getProject().getTasks();
            return task.equals(compare) || task.equals(tasks.findByName(task.toString()));
        }

        private void repackage(File file) {
            File outputFile = RepackageTask.this.outputFile;
            if (outputFile != null && !file.equals(outputFile)) {
                this.copy(file, outputFile);
                file = outputFile;
            }
            LoggingRepackager repackager = new LoggingRepackager(file);
            this.setMainClass(repackager);
            if (this.extension.convertLayout() != null) {
                repackager.setLayout(this.extension.convertLayout());
            }
            repackager.setBackupSource(this.extension.isBackupSource());
            try {
                repackager.repackage(file, this.libraries);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }

        private void copy(File source, File dest) {
            try {
                FileCopyUtils.copy((File)source, (File)dest);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }

        private void setMainClass(Repackager repackager) {
            String mainClass = (String)RepackageTask.this.getProject().property("mainClassName");
            if (RepackageTask.this.mainClass != null) {
                mainClass = RepackageTask.this.mainClass;
            } else if (this.extension.getMainClass() != null) {
                mainClass = this.extension.getMainClass();
            } else if (RepackageTask.this.getProject().getTasks().getByName("run").hasProperty("main")) {
                mainClass = (String)RepackageTask.this.getProject().getTasks().getByName("run").property("main");
            }
            RepackageTask.this.getLogger().info("Setting mainClass: " + mainClass);
            repackager.setMainClass(mainClass);
        }
    }
}

