/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.repackage;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;

class ProjectLibraries
implements Libraries {
    private final Project project;
    private final SpringBootPluginExtension extension;
    private String providedConfigurationName = "providedRuntime";
    private String customConfigurationName = null;

    public ProjectLibraries(Project project, SpringBootPluginExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public void setProvidedConfigurationName(String providedConfigurationName) {
        this.providedConfigurationName = providedConfigurationName;
    }

    public void setCustomConfigurationName(String customConfigurationName) {
        this.customConfigurationName = customConfigurationName;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Set<Library> custom = this.getLibraries(this.customConfigurationName, LibraryScope.CUSTOM);
        if (custom != null) {
            this.libraries(custom, callback);
        } else {
            Set<Library> compile = this.getLibraries("compile", LibraryScope.COMPILE);
            Set<Library> runtime = this.getLibraries("runtime", LibraryScope.RUNTIME);
            runtime = this.minus(runtime, compile);
            Set<Library> provided = this.getLibraries(this.providedConfigurationName, LibraryScope.PROVIDED);
            if (provided != null) {
                compile = this.minus(compile, provided);
                runtime = this.minus(runtime, provided);
            }
            this.libraries(compile, callback);
            this.libraries(runtime, callback);
            this.libraries(provided, callback);
        }
    }

    private Set<Library> getLibraries(String configurationName, LibraryScope scope) {
        Configuration configuration;
        Configuration configuration2 = configuration = configurationName == null ? null : (Configuration)this.project.getConfigurations().findByName(configurationName);
        if (configuration == null) {
            return null;
        }
        LinkedHashSet<Library> libraries = new LinkedHashSet<Library>();
        for (ResolvedArtifact artifact : configuration.getResolvedConfiguration().getResolvedArtifacts()) {
            libraries.add(new ResolvedArtifactLibrary(artifact, scope));
        }
        for (Dependency dependency : configuration.getIncoming().getDependencies()) {
            if (!(dependency instanceof FileCollectionDependency)) continue;
            FileCollectionDependency fileDependency = (FileCollectionDependency)dependency;
            for (File file : fileDependency.resolve()) {
                libraries.add(new Library(file, scope));
            }
        }
        return libraries;
    }

    private Set<Library> minus(Set<Library> source, Set<Library> toRemove) {
        if (source == null || toRemove == null) {
            return source;
        }
        HashSet<File> filesToRemove = new HashSet<File>();
        for (Library library : toRemove) {
            filesToRemove.add(library.getFile());
        }
        LinkedHashSet<Library> result = new LinkedHashSet<Library>();
        for (Library library : source) {
            if (filesToRemove.contains(library.getFile())) continue;
            result.add(library);
        }
        return result;
    }

    private void libraries(Set<Library> libraries, LibraryCallback callback) throws IOException {
        if (libraries != null) {
            for (Library library : libraries) {
                callback.library(library);
            }
        }
    }

    private class ResolvedArtifactLibrary
    extends Library {
        private final ResolvedArtifact artifact;

        public ResolvedArtifactLibrary(ResolvedArtifact artifact, LibraryScope scope) {
            super(artifact.getFile(), scope);
            this.artifact = artifact;
        }

        public boolean isUnpackRequired() {
            if (ProjectLibraries.this.extension.getRequiresUnpack() != null) {
                ModuleVersionIdentifier id = this.artifact.getModuleVersion().getId();
                return ProjectLibraries.this.extension.getRequiresUnpack().contains(String.valueOf(id.getGroup()) + ":" + id.getName());
            }
            return false;
        }
    }
}

