/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.run;

import java.io.File;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.run.SourceSets;
import org.springframework.boot.loader.tools.MainClassFinder;

public class FindMainClassTask
extends DefaultTask {
    @TaskAction
    public void setMainClassNameProperty() {
        Project project = this.getProject();
        if (project.property("mainClassName") == null) {
            project.setProperty("mainClassName", (Object)this.findMainClass());
        }
    }

    private String findMainClass() {
        SourceSet mainSourceSet;
        Project project = this.getProject();
        String mainClass = null;
        SpringBootPluginExtension bootExtension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        if (bootExtension.getMainClass() != null) {
            mainClass = bootExtension.getMainClass();
        }
        ApplicationPluginConvention application = (ApplicationPluginConvention)project.getConvention().getPlugins().get("application");
        if (mainClass == null && application.getMainClassName() != null) {
            mainClass = application.getMainClassName();
        }
        Task runTask = this.getProject().getTasks().getByName("run");
        if (mainClass == null && runTask.hasProperty("main")) {
            mainClass = (String)runTask.property("main");
        }
        if (mainClass == null && (mainSourceSet = SourceSets.findMainSourceSet(project)) != null) {
            project.getLogger().debug("Looking for main in: " + mainSourceSet.getOutput().getClassesDir());
            try {
                mainClass = MainClassFinder.findSingleMainClass((File)mainSourceSet.getOutput().getClassesDir());
                project.getLogger().info("Computed main class: " + mainClass);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot find main class", ex);
            }
        }
        project.getLogger().info("Found main: " + mainClass);
        if (bootExtension.getMainClass() == null) {
            bootExtension.setMainClass(mainClass);
        }
        if (application.getMainClassName() == null) {
            application.setMainClassName(mainClass);
        }
        if (!runTask.hasProperty("main")) {
            runTask.setProperty("main", (Object)mainClass);
        }
        return mainClass;
    }
}

