/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.springframework.boot.gradle.plugin.MainClassConvention;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.tasks.bundling.BootWar;

class WarPluginAction
implements PluginApplicationAction {
    private final SinglePublishedArtifact singlePublishedArtifact;

    WarPluginAction(SinglePublishedArtifact singlePublishedArtifact) {
        this.singlePublishedArtifact = singlePublishedArtifact;
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return WarPlugin.class;
    }

    public void execute(Project project) {
        this.disableWarTask(project);
        TaskProvider<BootWar> bootWar = this.configureBootWarTask(project);
        this.configureArtifactPublication(bootWar);
    }

    private void disableWarTask(Project project) {
        project.getTasks().named("war").configure(war -> war.setEnabled(false));
    }

    private TaskProvider<BootWar> configureBootWarTask(Project project) {
        return project.getTasks().register("bootWar", BootWar.class, bootWar -> {
            bootWar.setGroup("build");
            bootWar.setDescription("Assembles an executable war archive containing webapp content, and the main classes and their dependencies.");
            bootWar.providedClasspath(this.providedRuntimeConfiguration(project));
            Configuration developmentOnly = project.getConfigurations().getByName("developmentOnly");
            Configuration productionRuntimeClasspath = project.getConfigurations().getByName("productionRuntimeClasspath");
            bootWar.setClasspath(bootWar.getClasspath().minus(developmentOnly.minus((FileCollection)productionRuntimeClasspath)));
            bootWar.conventionMapping("mainClassName", new MainClassConvention(project, () -> ((BootWar)bootWar).getClasspath()));
        });
    }

    private FileCollection providedRuntimeConfiguration(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        return configurations.getByName("providedRuntime");
    }

    private void configureArtifactPublication(TaskProvider<BootWar> bootWar) {
        LazyPublishArtifact artifact = new LazyPublishArtifact(bootWar);
        this.singlePublishedArtifact.addCandidate((PublishArtifact)artifact);
    }
}

