/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.Builder;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.ZipFileTarArchive;
import org.springframework.boot.gradle.util.VersionExtractor;
import org.springframework.util.StringUtils;

public class BootBuildImage
extends DefaultTask {
    private static final String BUILDPACK_JVM_VERSION_KEY = "BP_JVM_VERSION";
    private RegularFileProperty jar;
    private Property<JavaVersion> targetJavaVersion;
    private String imageName;
    private String builder;
    private String runImage;
    private Map<String, String> environment = new HashMap<String, String>();
    private boolean cleanCache;
    private boolean verboseLogging;

    public BootBuildImage() {
        this.jar = this.getProject().getObjects().fileProperty();
        this.targetJavaVersion = this.getProject().getObjects().property(JavaVersion.class);
    }

    @Input
    public RegularFileProperty getJar() {
        return this.jar;
    }

    @Input
    @Optional
    public Property<JavaVersion> getTargetJavaVersion() {
        return this.targetJavaVersion;
    }

    @Input
    @Optional
    public String getImageName() {
        return this.imageName;
    }

    @Option(option="imageName", description="The name of the image to generate")
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    @Input
    @Optional
    public String getBuilder() {
        return this.builder;
    }

    @Option(option="builder", description="The name of the builder image to use")
    public void setBuilder(String builder) {
        this.builder = builder;
    }

    @Input
    @Optional
    public String getRunImage() {
        return this.runImage;
    }

    @Option(option="runImage", description="The name of the run image to use")
    public void setRunImage(String runImage) {
        this.runImage = runImage;
    }

    @Input
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void environment(String name, String value) {
        this.environment.put(name, value);
    }

    public void environment(Map<String, String> entries) {
        this.environment.putAll(entries);
    }

    @Input
    public boolean isCleanCache() {
        return this.cleanCache;
    }

    public void setCleanCache(boolean cleanCache) {
        this.cleanCache = cleanCache;
    }

    @Input
    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    @TaskAction
    void buildImage() throws DockerEngineException, IOException {
        Builder builder = new Builder();
        BuildRequest request = this.createRequest();
        builder.build(request);
    }

    BuildRequest createRequest() {
        return this.customize(BuildRequest.of((ImageReference)this.determineImageReference(), owner -> new ZipFileTarArchive(((RegularFile)this.jar.get()).getAsFile(), owner)));
    }

    private ImageReference determineImageReference() {
        if (StringUtils.hasText((String)this.imageName)) {
            return ImageReference.of((String)this.imageName);
        }
        ImageName imageName = ImageName.of((String)this.getProject().getName());
        String version = this.getProject().getVersion().toString();
        if ("unspecified".equals(version)) {
            return ImageReference.of((ImageName)imageName);
        }
        return ImageReference.of((ImageName)imageName, (String)version);
    }

    private BuildRequest customize(BuildRequest request) {
        request = this.customizeBuilder(request);
        request = this.customizeRunImage(request);
        request = this.customizeEnvironment(request);
        request = this.customizeCreator(request);
        request = request.withCleanCache(this.cleanCache);
        request = request.withVerboseLogging(this.verboseLogging);
        return request;
    }

    private BuildRequest customizeBuilder(BuildRequest request) {
        if (StringUtils.hasText((String)this.builder)) {
            return request.withBuilder(ImageReference.of((String)this.builder));
        }
        return request;
    }

    private BuildRequest customizeRunImage(BuildRequest request) {
        if (StringUtils.hasText((String)this.runImage)) {
            return request.withRunImage(ImageReference.of((String)this.runImage));
        }
        return request;
    }

    private BuildRequest customizeEnvironment(BuildRequest request) {
        if (this.environment != null && !this.environment.isEmpty()) {
            request = request.withEnv(this.environment);
        }
        if (this.targetJavaVersion.isPresent() && !request.getEnv().containsKey(BUILDPACK_JVM_VERSION_KEY)) {
            request = request.withEnv(BUILDPACK_JVM_VERSION_KEY, this.translateTargetJavaVersion());
        }
        return request;
    }

    private BuildRequest customizeCreator(BuildRequest request) {
        String springBootVersion = VersionExtractor.forClass(BootBuildImage.class);
        if (StringUtils.hasText((String)springBootVersion)) {
            return request.withCreator(Creator.withVersion((String)springBootVersion));
        }
        return request;
    }

    private String translateTargetJavaVersion() {
        return ((JavaVersion)this.targetJavaVersion.get()).getMajorVersion() + ".*";
    }
}

