/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.tasks.bundling.BootArchive;
import org.springframework.boot.gradle.tasks.bundling.BootArchiveSupport;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.LayerResolver;
import org.springframework.boot.gradle.tasks.bundling.LayeredSpec;
import org.springframework.boot.gradle.tasks.bundling.ResolvedDependencies;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

public class BootJar
extends Jar
implements BootArchive {
    private static final String LAUNCHER = "org.springframework.boot.loader.JarLauncher";
    private static final String CLASSES_DIRECTORY = "BOOT-INF/classes/";
    private static final String LIB_DIRECTORY = "BOOT-INF/lib/";
    private static final String LAYERS_INDEX = "BOOT-INF/layers.idx";
    private static final String CLASSPATH_INDEX = "BOOT-INF/classpath.idx";
    private final ResolvedDependencies resolvedDependencies = new ResolvedDependencies();
    private final BootArchiveSupport support;
    private final CopySpec bootInfSpec;
    private final Property<String> mainClass;
    private FileCollection classpath;
    private LayeredSpec layered = new LayeredSpec();

    public BootJar() {
        this.support = new BootArchiveSupport(LAUNCHER, new LibrarySpec(), new ZipCompressionResolver());
        Project project = this.getProject();
        this.bootInfSpec = project.copySpec().into((Object)"BOOT-INF");
        this.mainClass = project.getObjects().property(String.class);
        this.configureBootInfSpec(this.bootInfSpec);
        this.getMainSpec().with(new CopySpec[]{this.bootInfSpec});
        project.getConfigurations().all(configuration -> {
            ResolvableDependencies incoming = configuration.getIncoming();
            incoming.afterResolve(resolvableDependencies -> {
                if (resolvableDependencies == incoming) {
                    this.resolvedDependencies.processConfiguration(project, (Configuration)configuration);
                }
            });
        });
    }

    private void configureBootInfSpec(CopySpec bootInfSpec) {
        bootInfSpec.into((Object)"classes", BootJar.fromCallTo(this::classpathDirectories));
        bootInfSpec.into((Object)"lib", BootJar.fromCallTo(this::classpathFiles)).eachFile(this.support::excludeNonZipFiles);
        this.support.moveModuleInfoToRoot(bootInfSpec);
        this.moveMetaInfToRoot(bootInfSpec);
    }

    private Iterable<File> classpathDirectories() {
        return this.classpathEntries((Spec<File>)((Spec)File::isDirectory));
    }

    private Iterable<File> classpathFiles() {
        return this.classpathEntries((Spec<File>)((Spec)File::isFile));
    }

    private Iterable<File> classpathEntries(Spec<File> filter) {
        return this.classpath != null ? this.classpath.filter(filter) : Collections.emptyList();
    }

    private void moveMetaInfToRoot(CopySpec spec) {
        spec.eachFile(file -> {
            String path = file.getRelativeSourcePath().getPathString();
            if (path.startsWith("META-INF/") && !path.equals("META-INF/aop.xml") && !path.endsWith(".kotlin_module")) {
                this.support.moveToRoot((FileCopyDetails)file);
            }
        });
    }

    public void copy() {
        this.support.configureManifest(this.getManifest(), (String)this.getMainClass().get(), CLASSES_DIRECTORY, LIB_DIRECTORY, CLASSPATH_INDEX, this.isLayeredDisabled() ? null : LAYERS_INDEX);
        super.copy();
    }

    private boolean isLayeredDisabled() {
        return this.layered != null && !this.layered.isEnabled();
    }

    protected CopyAction createCopyAction() {
        if (!this.isLayeredDisabled()) {
            LayerResolver layerResolver = new LayerResolver(this.resolvedDependencies, this.layered, (Spec<FileCopyDetails>)((Spec)this::isLibrary));
            String layerToolsLocation = this.layered.isIncludeLayerTools() ? LIB_DIRECTORY : null;
            return this.support.createCopyAction(this, layerResolver, layerToolsLocation);
        }
        return this.support.createCopyAction(this);
    }

    @Override
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Override
    @Deprecated
    public String getMainClassName() {
        return (String)this.mainClass.getOrNull();
    }

    @Override
    @Deprecated
    public void setMainClassName(String mainClassName) {
        this.mainClass.set((Object)mainClassName);
    }

    @Override
    public void requiresUnpack(String ... patterns) {
        this.support.requiresUnpack(patterns);
    }

    @Override
    public void requiresUnpack(Spec<FileTreeElement> spec) {
        this.support.requiresUnpack(spec);
    }

    @Override
    public LaunchScriptConfiguration getLaunchScript() {
        return this.support.getLaunchScript();
    }

    @Override
    public void launchScript() {
        this.enableLaunchScriptIfNecessary();
    }

    @Override
    public void launchScript(Action<LaunchScriptConfiguration> action) {
        action.execute((Object)this.enableLaunchScriptIfNecessary());
    }

    @Nested
    public LayeredSpec getLayered() {
        return this.layered;
    }

    @Deprecated
    public void layered() {
    }

    public void layered(Action<LayeredSpec> action) {
        action.execute((Object)this.layered);
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void classpath(Object ... classpath) {
        FileCollection existingClasspath = this.classpath;
        this.classpath = this.getProject().files(new Object[]{existingClasspath != null ? existingClasspath : Collections.emptyList(), classpath});
    }

    @Override
    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Internal
    public CopySpec getBootInf() {
        CopySpec child = this.getProject().copySpec();
        this.bootInfSpec.with(new CopySpec[]{child});
        return child;
    }

    public CopySpec bootInf(Action<CopySpec> action) {
        CopySpec bootInf = this.getBootInf();
        action.execute((Object)bootInf);
        return bootInf;
    }

    protected ZipCompression resolveZipCompression(FileCopyDetails details) {
        return this.isLibrary(details) ? ZipCompression.STORED : ZipCompression.DEFLATED;
    }

    protected boolean isLibrary(FileCopyDetails details) {
        String path = details.getRelativePath().getPathString();
        return path.startsWith(LIB_DIRECTORY);
    }

    private LaunchScriptConfiguration enableLaunchScriptIfNecessary() {
        LaunchScriptConfiguration launchScript = this.support.getLaunchScript();
        if (launchScript == null) {
            launchScript = new LaunchScriptConfiguration((AbstractArchiveTask)this);
            this.support.setLaunchScript(launchScript);
        }
        return launchScript;
    }

    private static <T> Action<CopySpec> fromCallTo(Callable<T> callable) {
        return spec -> spec.from(new Object[]{BootJar.callTo(callable)});
    }

    private static <T> Callable<T> callTo(Callable<T> callable) {
        return callable;
    }

    @Internal
    ResolvedDependencies getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    private final class ZipCompressionResolver
    implements Function<FileCopyDetails, ZipCompression> {
        private ZipCompressionResolver() {
        }

        @Override
        public ZipCompression apply(FileCopyDetails details) {
            return BootJar.this.resolveZipCompression(details);
        }
    }

    private final class LibrarySpec
    implements Spec<FileCopyDetails> {
        private LibrarySpec() {
        }

        public boolean isSatisfiedBy(FileCopyDetails details) {
            return BootJar.this.isLibrary(details);
        }
    }
}

