/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.imperative;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;

@ConfigurationProperties(value="spring.http.clients.imperative")
public class ImperativeHttpClientsProperties {
    private @Nullable Factory factory;

    public @Nullable Factory getFactory() {
        return this.factory;
    }

    public void setFactory(@Nullable Factory factory) {
        this.factory = factory;
    }

    public static enum Factory {
        HTTP_COMPONENTS(ClientHttpRequestFactoryBuilder::httpComponents),
        JETTY(ClientHttpRequestFactoryBuilder::jetty),
        REACTOR(ClientHttpRequestFactoryBuilder::reactor),
        JDK(ClientHttpRequestFactoryBuilder::jdk),
        SIMPLE(ClientHttpRequestFactoryBuilder::simple);

        private final Supplier<ClientHttpRequestFactoryBuilder<?>> builderSupplier;

        private Factory(Supplier<ClientHttpRequestFactoryBuilder<?>> builderSupplier) {
            this.builderSupplier = builderSupplier;
        }

        ClientHttpRequestFactoryBuilder<?> builder() {
            return this.builderSupplier.get();
        }
    }
}

