/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.layertools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.springframework.boot.jarmode.layertools.Context;
import org.springframework.boot.jarmode.layertools.Layers;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

class IndexedLayers
implements Layers {
    private final Map<String, List<String>> layers = new LinkedHashMap<String, List<String>>();

    IndexedLayers(String indexFile) {
        String[] lines = (String[])Arrays.stream(indexFile.split("\n")).map(line -> line.replace("\r", "")).filter(StringUtils::hasText).toArray(String[]::new);
        ArrayList<String> contents = null;
        for (String line2 : lines) {
            if (line2.startsWith("- ")) {
                contents = new ArrayList<String>();
                this.layers.put(line2.substring(3, line2.length() - 2), contents);
                continue;
            }
            if (line2.startsWith("  - ")) {
                contents.add(line2.substring(5, line2.length() - 1));
                continue;
            }
            throw new IllegalStateException("Layer index file is malformed");
        }
        Assert.state((!this.layers.isEmpty() ? 1 : 0) != 0, (String)"Empty layer index file loaded");
    }

    @Override
    public Iterator<String> iterator() {
        return this.layers.keySet().iterator();
    }

    @Override
    public String getLayer(ZipEntry entry) {
        return this.getLayer(entry.getName());
    }

    private String getLayer(String name) {
        for (Map.Entry<String, List<String>> entry : this.layers.entrySet()) {
            for (String candidate : entry.getValue()) {
                if (!candidate.equals(name) && (!candidate.endsWith("/") || !name.startsWith(candidate))) continue;
                return entry.getKey();
            }
        }
        throw new IllegalStateException("No layer defined in index for file '" + name + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IndexedLayers get(Context context) {
        try (JarFile jarFile = new JarFile(context.getJarFile());){
            ZipEntry entry = jarFile.getEntry("BOOT-INF/layers.idx");
            if (entry == null) return null;
            String indexFile = StreamUtils.copyToString((InputStream)jarFile.getInputStream(entry), (Charset)StandardCharsets.UTF_8);
            IndexedLayers indexedLayers = new IndexedLayers(indexFile);
            return indexedLayers;
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            return null;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

