/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.util.Assert;

public interface JdbcConnectionDetails
extends ConnectionDetails {
    public @Nullable String getUsername();

    public @Nullable String getPassword();

    public String getJdbcUrl();

    default public String getDriverClassName() {
        String driverClassName = DatabaseDriver.fromJdbcUrl(this.getJdbcUrl()).getDriverClassName();
        Assert.state((driverClassName != null ? 1 : 0) != 0, (String)"'driverClassName' must not be null");
        return driverClassName;
    }

    default public @Nullable String getXaDataSourceClassName() {
        return DatabaseDriver.fromJdbcUrl(this.getJdbcUrl()).getXaDataSourceClassName();
    }
}

