/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.kotlinx.serialization.json.autoconfigure;

import java.util.List;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNamingStrategy;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.kotlinx.serialization.json.autoconfigure.KotlinxSerializationJsonBuilderCustomizer;
import org.springframework.boot.kotlinx.serialization.json.autoconfigure.KotlinxSerializationJsonProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

@AutoConfiguration
@ConditionalOnClass(value={Json.class})
@EnableConfigurationProperties(value={KotlinxSerializationJsonProperties.class})
public final class KotlinxSerializationJsonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Json kotlinSerializationJson(List<KotlinxSerializationJsonBuilderCustomizer> customizers) {
        Function1 builderAction = jsonBuilder -> {
            customizers.forEach(c -> c.customize((JsonBuilder)jsonBuilder));
            return Unit.INSTANCE;
        };
        return JsonKt.Json((Json)Json.Default, (Function1)builderAction);
    }

    @Bean
    StandardKotlinSerializationJsonBuilderCustomizer standardKotlinSerializationJsonBuilderCustomizer(KotlinxSerializationJsonProperties kotlinSerializationProperties) {
        return new StandardKotlinSerializationJsonBuilderCustomizer(kotlinSerializationProperties);
    }

    static final class StandardKotlinSerializationJsonBuilderCustomizer
    implements KotlinxSerializationJsonBuilderCustomizer,
    Ordered {
        private final KotlinxSerializationJsonProperties properties;

        StandardKotlinSerializationJsonBuilderCustomizer(KotlinxSerializationJsonProperties properties) {
            this.properties = properties;
        }

        public int getOrder() {
            return 0;
        }

        @Override
        public void customize(JsonBuilder jsonBuilder) {
            KotlinxSerializationJsonProperties properties = this.properties;
            PropertyMapper map = PropertyMapper.get();
            map.from(properties::getNamingStrategy).to(this.setNamingStrategy(jsonBuilder));
            map.from(properties::isPrettyPrint).to(arg_0 -> ((JsonBuilder)jsonBuilder).setPrettyPrint(arg_0));
            map.from(properties::isLenient).to(arg_0 -> ((JsonBuilder)jsonBuilder).setLenient(arg_0));
            map.from(properties::isIgnoreUnknownKeys).to(arg_0 -> ((JsonBuilder)jsonBuilder).setIgnoreUnknownKeys(arg_0));
            map.from(properties::isEncodeDefaults).to(arg_0 -> ((JsonBuilder)jsonBuilder).setEncodeDefaults(arg_0));
            map.from(properties::isExplicitNulls).to(arg_0 -> ((JsonBuilder)jsonBuilder).setExplicitNulls(arg_0));
            map.from(properties::isCoerceInputValues).to(arg_0 -> ((JsonBuilder)jsonBuilder).setCoerceInputValues(arg_0));
            map.from(properties::isAllowStructuredMapKeys).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowStructuredMapKeys(arg_0));
            map.from(properties::isAllowSpecialFloatingPointValues).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowSpecialFloatingPointValues(arg_0));
            map.from(properties::getClassDiscriminator).to(arg_0 -> ((JsonBuilder)jsonBuilder).setClassDiscriminator(arg_0));
            map.from(properties::getClassDiscriminatorMode).to(arg_0 -> ((JsonBuilder)jsonBuilder).setClassDiscriminatorMode(arg_0));
            map.from(properties::isDecodeEnumsCaseInsensitive).to(arg_0 -> ((JsonBuilder)jsonBuilder).setDecodeEnumsCaseInsensitive(arg_0));
            map.from(properties::isUseAlternativeNames).to(arg_0 -> ((JsonBuilder)jsonBuilder).setUseAlternativeNames(arg_0));
            map.from(properties::isAllowTrailingComma).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowTrailingComma(arg_0));
            map.from(properties::isAllowComments).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowComments(arg_0));
        }

        private Consumer<KotlinxSerializationJsonProperties.JsonNamingStrategy> setNamingStrategy(JsonBuilder builder) {
            return strategy -> {
                JsonNamingStrategy namingStrategy = switch (strategy) {
                    default -> throw new IncompatibleClassChangeError();
                    case KotlinxSerializationJsonProperties.JsonNamingStrategy.SNAKE_CASE -> JsonNamingStrategy.Builtins.getSnakeCase();
                    case KotlinxSerializationJsonProperties.JsonNamingStrategy.KEBAB_CASE -> JsonNamingStrategy.Builtins.getKebabCase();
                };
                builder.setNamingStrategy(namingStrategy);
            };
        }
    }
}

