/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ldap.autoconfigure;

import java.util.Collections;
import java.util.Locale;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.boot.ldap.autoconfigure.LdapConnectionDetails;
import org.springframework.boot.ldap.autoconfigure.LdapProperties;
import org.springframework.boot.ldap.autoconfigure.PropertiesLdapConnectionDetails;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.env.Environment;
import org.springframework.ldap.convert.ConverterUtils;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.odm.core.impl.DefaultObjectDirectoryMapper;

@AutoConfiguration
@ConditionalOnClass(value={ContextSource.class})
@EnableConfigurationProperties(value={LdapProperties.class})
public final class LdapAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LdapConnectionDetails.class})
    PropertiesLdapConnectionDetails propertiesLdapConnectionDetails(LdapProperties properties, Environment environment) {
        return new PropertiesLdapConnectionDetails(properties, environment);
    }

    @Bean
    @ConditionalOnMissingBean
    LdapContextSource ldapContextSource(LdapConnectionDetails connectionDetails, LdapProperties properties, ObjectProvider<DirContextAuthenticationStrategy> dirContextAuthenticationStrategy) {
        LdapContextSource source = new LdapContextSource();
        dirContextAuthenticationStrategy.ifUnique(arg_0 -> ((LdapContextSource)source).setAuthenticationStrategy(arg_0));
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from((Object)connectionDetails.getUsername()).to(arg_0 -> ((LdapContextSource)source).setUserDn(arg_0));
        propertyMapper.from((Object)connectionDetails.getPassword()).to(arg_0 -> ((LdapContextSource)source).setPassword(arg_0));
        propertyMapper.from((Object)properties.getAnonymousReadOnly()).to(arg_0 -> ((LdapContextSource)source).setAnonymousReadOnly(arg_0));
        propertyMapper.from((Object)properties.getReferral()).as(referral -> referral.name().toLowerCase(Locale.ROOT)).to(arg_0 -> ((LdapContextSource)source).setReferral(arg_0));
        propertyMapper.from((Object)connectionDetails.getBase()).to(arg_0 -> ((LdapContextSource)source).setBase(arg_0));
        propertyMapper.from((Object)connectionDetails.getUrls()).to(arg_0 -> ((LdapContextSource)source).setUrls(arg_0));
        propertyMapper.from(properties.getBaseEnvironment()).to(baseEnvironment -> source.setBaseEnvironmentProperties(Collections.unmodifiableMap(baseEnvironment)));
        return source;
    }

    @Bean
    @ConditionalOnMissingBean
    ObjectDirectoryMapper objectDirectoryMapper() {
        ApplicationConversionService conversionService = new ApplicationConversionService();
        ConverterUtils.addDefaultConverters((ConverterRegistry)conversionService);
        DefaultObjectDirectoryMapper objectDirectoryMapper = new DefaultObjectDirectoryMapper();
        objectDirectoryMapper.setConversionService((ConversionService)conversionService);
        return objectDirectoryMapper;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapOperations.class})
    LdapTemplate ldapTemplate(LdapProperties properties, ContextSource contextSource, ObjectDirectoryMapper objectDirectoryMapper) {
        LdapProperties.Template template = properties.getTemplate();
        PropertyMapper propertyMapper = PropertyMapper.get();
        LdapTemplate ldapTemplate = new LdapTemplate(contextSource);
        ldapTemplate.setObjectDirectoryMapper(objectDirectoryMapper);
        propertyMapper.from((Object)template.isIgnorePartialResultException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnorePartialResultException(arg_0));
        propertyMapper.from((Object)template.isIgnoreNameNotFoundException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreNameNotFoundException(arg_0));
        propertyMapper.from((Object)template.isIgnoreSizeLimitExceededException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreSizeLimitExceededException(arg_0));
        return ldapTemplate;
    }
}

